/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

public final class Stopwatch {
    private boolean myTimerIsRunning;
    private long myStart;
    private long myStop;

    public void start() {
        if (this.myTimerIsRunning) {
            throw new IllegalStateException("Must stop before calling start again.");
        }
        this.myStart = System.currentTimeMillis();
        this.myTimerIsRunning = true;
    }

    public void stop() {
        if (!this.myTimerIsRunning) {
            throw new IllegalStateException("Cannot stop if not currently running.");
        }
        this.myStop = System.currentTimeMillis();
        this.myTimerIsRunning = false;
    }

    public void stopAfter(int aSecondsCount) {
        int stopCount = aSecondsCount;
        if (!this.myTimerIsRunning) {
            throw new IllegalStateException("Cannot stop if not currently running");
        }
        while (stopCount < aSecondsCount) {
            stopCount = (int)(System.currentTimeMillis() - this.myStart) / 1000;
        }
        this.myStop = System.currentTimeMillis();
        this.myTimerIsRunning = false;
    }

    public String getSeconds() {
        StringBuilder result = new StringBuilder();
        long timeGap = this.myStop - this.myStart;
        result.append(timeGap / 1000L);
        result.append(" secs, ");
        result.append(timeGap % 1000L);
        result.append(" msecs");
        if (this.myTimerIsRunning) {
            throw new IllegalStateException("Must stop first.");
        }
        return result.toString();
    }

    public String getMilliseconds() {
        StringBuilder result = new StringBuilder();
        result.append(this.myStop - this.myStart);
        result.append(" msecs");
        if (this.myTimerIsRunning) {
            throw new IllegalStateException("Must stop first.");
        }
        return result.toString();
    }

    public String toString() {
        return "Stopwatch milliseconds elapsed: " + this.getMilliseconds();
    }
}

