/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.FileUtils;
import info.freelibrary.util.IOUtils;
import info.freelibrary.util.PairtreeObject;
import info.freelibrary.util.StringUtils;
import info.freelibrary.util.XMLBundleControl;
import info.freelibrary.util.XMLResourceBundle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairtreeRoot
extends File {
    public static final String PT_VERSION_NUM = "0.1";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final long serialVersionUID = 148951612898582350L;
    private static final String PAIRTREE_PREFIX = "pairtree_prefix";
    private static final String PAIRTREE_ROOT = "pairtree_root";
    private static final String PAIRTREE_VERSION = "pairtree_version";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final XMLResourceBundle BUNDLE = (XMLResourceBundle)ResourceBundle.getBundle("freelib-utils_messages", new XMLBundleControl());
    private static final Logger LOGGER = LoggerFactory.getLogger(PairtreeRoot.class);
    private String myPairtreePrefix;

    public PairtreeRoot(String aParentDirPath) throws IOException {
        this(new File(aParentDirPath));
    }

    public PairtreeRoot(String aParentDirPath, String aPairtreePrefix) throws IOException {
        this(new File(aParentDirPath), aPairtreePrefix);
    }

    public PairtreeRoot(File aParentDir) throws IOException {
        this(aParentDir, null);
    }

    public PairtreeRoot(File aParentDir, String aPairtreePrefix) throws IOException {
        super(aParentDir, PAIRTREE_ROOT);
        if (aPairtreePrefix != null) {
            File prefixFile = new File(aParentDir, PAIRTREE_PREFIX);
            this.myPairtreePrefix = aPairtreePrefix;
            this.writePrefixFile(prefixFile, this.getPairtreePrefix());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(BUNDLE.get("pt.retrieving_root", aParentDir));
            if (aPairtreePrefix != null) {
                LOGGER.debug(BUNDLE.get("pt.using_prefix", this.myPairtreePrefix));
            }
        }
        if (!this.exists() && !this.mkdirs()) {
            throw new IOException(BUNDLE.get("pt.cant_mkdirs", (File)this));
        }
        this.writeVersionFile(new File(aParentDir, this.getVersionFileName()));
    }

    public PairtreeObject getObject(String aName) throws IOException {
        return this.myPairtreePrefix == null ? new PairtreeObject(this, aName) : new PairtreeObject(this, this.myPairtreePrefix, aName);
    }

    @Override
    public boolean delete() {
        File prefixFile = new File(this.getParentFile(), PAIRTREE_PREFIX);
        File ptVersion = new File(this.getParentFile(), this.getVersionFileName());
        boolean result = true;
        if (prefixFile.exists() && !prefixFile.delete()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to delete pairtree prefix file");
            }
            result = false;
        }
        if (ptVersion.exists() && !ptVersion.delete()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to delete pairtree version file");
            }
            result = false;
        }
        for (File file : this.listFiles()) {
            if (FileUtils.delete(file)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to delete " + file);
            }
            result = false;
        }
        if (!super.delete()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to delete pairtree directory");
            }
            result = false;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myPairtreePrefix == null ? 0 : this.myPairtreePrefix.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        if (this.getClass() != aObject.getClass()) {
            return false;
        }
        PairtreeRoot other = (PairtreeRoot)aObject;
        return !(this.myPairtreePrefix == null ? other.myPairtreePrefix != null : !this.myPairtreePrefix.equals(other.myPairtreePrefix));
    }

    private String getPairtreePrefix() {
        return this.myPairtreePrefix;
    }

    private String getVersionFileName() {
        return PAIRTREE_VERSION + PT_VERSION_NUM.replace('.', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVersionFile(File aFile) throws IOException {
        if (!aFile.exists()) {
            OutputStreamWriter writer = null;
            try {
                FileOutputStream fileOut = new FileOutputStream(aFile);
                writer = new OutputStreamWriter((OutputStream)fileOut, DEFAULT_CHARSET);
                writer.write(BUNDLE.get("pt.verfile.content1", PT_VERSION_NUM));
                writer.write(LINE_SEP);
                writer.write(BUNDLE.get("pt.verfile.content2"));
                writer.write(LINE_SEP);
                writer.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePrefixFile(File aFile, String aPtPrefix) throws IOException {
        block4: {
            block3: {
                if (aFile.exists()) break block3;
                OutputStreamWriter writer = null;
                try {
                    FileOutputStream fileOut = new FileOutputStream(aFile);
                    writer = new OutputStreamWriter((OutputStream)fileOut, DEFAULT_CHARSET);
                    writer.write(aPtPrefix);
                    writer.write(LINE_SEP);
                    writer.close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
                IOUtils.closeQuietly(writer);
                break block4;
            }
            String prefix = StringUtils.read(aFile, DEFAULT_CHARSET);
            if (!prefix.equals(aPtPrefix)) {
                throw new IOException(BUNDLE.get("pt.bad_prefix", prefix, aPtPrefix));
            }
        }
    }
}

