/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.PairtreeRoot;
import info.freelibrary.util.PairtreeUtils;
import info.freelibrary.util.XMLBundleControl;
import info.freelibrary.util.XMLResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairtreeObject
extends File {
    private static final long serialVersionUID = 5022790117870380626L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PairtreeObject.class);
    private static final XMLResourceBundle BUNDLE = (XMLResourceBundle)ResourceBundle.getBundle("freelib-utils_messages", new XMLBundleControl());

    PairtreeObject(PairtreeRoot aRoot, String aName) throws IOException {
        super(aRoot, PairtreeUtils.mapToPtPath(aName));
        if (!this.exists() && !this.mkdirs()) {
            throw new IOException(BUNDLE.get("pt.cant_mkdirs", (File)this));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.debug(BUNDLE.get("pt.object_retrieved1", this.getAbsolutePath(), aName));
        }
    }

    PairtreeObject(PairtreeRoot aRoot, String aPrefix, String aName) throws IOException {
        super(aRoot, PairtreeUtils.mapToPtPath(aPrefix, aName));
        if (!this.exists() && !this.mkdirs()) {
            throw new IOException(BUNDLE.get("pt.cant_mkdirs", (File)this));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.debug(BUNDLE.get("pt.object_retrieved2", this.getAbsolutePath(), aPrefix, aName));
        }
    }

    @Override
    public String toString() {
        return this.getAbsolutePath();
    }
}

