/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.XMLBundleControl;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarClassLoader.class);
    private static final ResourceBundle RB = ResourceBundle.getBundle("Messages", new XMLBundleControl());
    private static final String CLASSPATH = "java.class.path";
    private static final String MAIN_JAR = System.getProperty("java.class.path");
    private static final String PATH = System.getProperty("user.home") + "/";
    private static final String HOME = System.getProperty("user.dir") + "/";
    private static final String JAR_URL_PROTOCOL = "jar:file://";

    public JarClassLoader(String aMainClassName) throws Exception {
        super(JarClassLoader.getJarURLs());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(RB.getString("jarClassLoader.init"), (Object)aMainClassName);
        }
        this.loadClass(aMainClassName).newInstance();
    }

    public JarClassLoader(URL[] aURLs, String aMainClassName) throws Exception {
        super(aURLs);
        this.loadClass(aMainClassName).newInstance();
    }

    public JarClassLoader(List<URL> aListOfURLs, String aMainClassName) throws Exception {
        super(aListOfURLs.toArray(new URL[aListOfURLs.size()]));
        this.loadClass(aMainClassName).newInstance();
    }

    @Override
    public Class<?> loadClass(String aName) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(aName);
        if (loadedClass == null) {
            try {
                loadedClass = this.findClass(aName);
            }
            catch (ClassNotFoundException details) {
                loadedClass = super.loadClass(aName);
            }
        }
        return loadedClass;
    }

    private static URL[] getJarURLs() throws IOException {
        JarFile jarFile = new JarFile(MAIN_JAR);
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        String classpath = attributes.getValue("Class-Path");
        StringTokenizer tokenizer = new StringTokenizer(classpath);
        LinkedList<URL> urlList = new LinkedList<URL>();
        urlList.add(new URL(JAR_URL_PROTOCOL + HOME + MAIN_JAR + "!/"));
        while (tokenizer.hasMoreTokens()) {
            String jarPath = tokenizer.nextToken();
            urlList.add(new URL(JAR_URL_PROTOCOL + PATH + jarPath + "!/"));
        }
        jarFile.close();
        return urlList.toArray(new URL[urlList.size()]);
    }
}

