/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtils.class);

    public static final void closeQuietly(Reader aReader) {
        block3: {
            if (aReader != null) {
                try {
                    aReader.close();
                }
                catch (IOException details) {
                    if (!LOGGER.isErrorEnabled()) break block3;
                    LOGGER.error(details.getMessage(), (Throwable)details);
                }
            }
        }
    }

    public static final void closeQuietly(Writer aWriter) {
        block3: {
            if (aWriter != null) {
                try {
                    aWriter.close();
                }
                catch (IOException details) {
                    if (!LOGGER.isErrorEnabled()) break block3;
                    LOGGER.error(details.getMessage(), (Throwable)details);
                }
            }
        }
    }

    public static final void closeQuietly(InputStream aInputStream) {
        block3: {
            if (aInputStream != null) {
                try {
                    aInputStream.close();
                }
                catch (IOException details) {
                    if (!LOGGER.isErrorEnabled()) break block3;
                    LOGGER.error(details.getMessage(), (Throwable)details);
                }
            }
        }
    }

    public static final void closeQuietly(OutputStream aOutputStream) {
        block3: {
            if (aOutputStream != null) {
                try {
                    aOutputStream.close();
                }
                catch (IOException details) {
                    if (!LOGGER.isErrorEnabled()) break block3;
                    LOGGER.error(details.getMessage(), (Throwable)details);
                }
            }
        }
    }

    public static final void closeQuietly(JarFile aJarFile) {
        block3: {
            if (aJarFile != null) {
                try {
                    aJarFile.close();
                }
                catch (IOException details) {
                    if (!LOGGER.isErrorEnabled()) break block3;
                    LOGGER.error(details.getMessage(), (Throwable)details);
                }
            }
        }
    }

    public static final void copyStream(InputStream aInStream, OutputStream aOutStream) throws IOException {
        BufferedOutputStream outStream = new BufferedOutputStream(aOutStream);
        BufferedInputStream inStream = new BufferedInputStream(aInStream);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = inStream.read(buffer)) != -1) {
            byteStream.write(buffer, 0, bytesRead);
        }
        outStream.write(byteStream.toByteArray());
        outStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyStream(File aFile, OutputStream aOutStream) throws IOException {
        FileInputStream input = new FileInputStream(aFile);
        FileChannel channel = input.getChannel();
        byte[] buffer = new byte[262144];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        try {
            int length = 0;
            while ((length = channel.read(byteBuffer)) != -1) {
                aOutStream.write(buffer, 0, length);
                byteBuffer.clear();
            }
        }
        finally {
            input.close();
        }
    }
}

