/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.StringUtils;
import info.freelibrary.util.XMLBundleControl;
import info.freelibrary.util.XMLResourceBundle;
import java.io.File;
import java.util.ResourceBundle;

public abstract class I18nObject {
    private final XMLResourceBundle BUNDLE;

    public I18nObject() {
        this.BUNDLE = (XMLResourceBundle)ResourceBundle.getBundle("messages", new XMLBundleControl());
    }

    public I18nObject(String aBundleName) {
        this.BUNDLE = (XMLResourceBundle)ResourceBundle.getBundle(aBundleName.toLowerCase(), new XMLBundleControl());
    }

    protected String getI18n(String aMessage) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessage));
    }

    protected String getI18n(String aMessage, long aLongDetail) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessage, Long.toString(aLongDetail)));
    }

    protected String getI18n(String aMessage, int aIntDetail) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessage, Integer.toString(aIntDetail)));
    }

    protected String getI18n(String aMessage, String aDetail) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessage, aDetail));
    }

    protected String getI18n(String aMessage, String ... aDetailsArray) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessage, aDetailsArray));
    }

    protected String getI18n(String aMessage, Exception aException) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessage, aException.getMessage()));
    }

    protected String getI18n(String aMessage, File aFile) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessage, aFile.getAbsolutePath()));
    }

    protected String getI18n(String aMessage, File ... aFileArray) {
        String[] fileNames = new String[aFileArray.length];
        for (int index = 0; index < fileNames.length; ++index) {
            fileNames[index] = aFileArray[index].getAbsolutePath();
        }
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessage, fileNames));
    }

    protected String getI18n(String aMessage, Object ... aObjArray) {
        String[] strings = new String[aObjArray.length];
        for (int index = 0; index < aObjArray.length; ++index) {
            strings[index] = aObjArray[index] instanceof File ? ((File)aObjArray[index]).getAbsolutePath() : aObjArray[index].toString();
        }
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessage, strings));
    }

    protected boolean hasI18nKey(String aKey) {
        return this.BUNDLE.containsKey(aKey);
    }
}

