/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;

public class FileExtFileFilter
implements FilenameFilter {
    private String[] myExtensions;

    public FileExtFileFilter(String aFileExt) {
        this.myExtensions = new String[]{"." + aFileExt};
    }

    public FileExtFileFilter(String ... aFileExtList) {
        this.myExtensions = new String[aFileExtList.length];
        for (int index = 0; index < aFileExtList.length; ++index) {
            this.myExtensions[index] = "." + aFileExtList[index];
        }
    }

    public String toString() {
        return Arrays.toString(this.myExtensions);
    }

    @Override
    public boolean accept(File aDir, String aFileName) {
        for (String extension : this.myExtensions) {
            if (!new File(aDir, aFileName).isFile() || !aFileName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public boolean filters(String aFileExt) {
        for (String extension : this.myExtensions) {
            if (!extension.equals("." + aFileExt)) continue;
            return true;
        }
        return false;
    }
}

