/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.FileExtFileFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathUtils {
    private static final String CLASSPATH = "java.class.path";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathUtils.class);

    public static String[] getDirs() {
        ArrayList<String> list = new ArrayList<String>();
        for (String filename : System.getProperty(CLASSPATH).split(":")) {
            File file = new File(filename);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Checking to see if {} is a dir ({})", (Object)file.getAbsolutePath(), (Object)(file.isDirectory() ? "yes" : "no"));
            }
            if (!file.isDirectory()) continue;
            list.add(file.getAbsolutePath());
        }
        return list.toArray(new String[list.size()]);
    }

    public static File[] getDirFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (String filename : System.getProperty(CLASSPATH).split(":")) {
            File file = new File(filename);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Checking to see if {} is a dir ({})", (Object)file.getAbsolutePath(), (Object)(file.isDirectory() ? "yes" : "no"));
            }
            if (!file.isDirectory()) continue;
            list.add(file);
        }
        return list.toArray(new File[list.size()]);
    }

    public static String[] getDirs(FilenameFilter aFilter) {
        ArrayList<String> list = new ArrayList<String>();
        for (String filename : System.getProperty(CLASSPATH).split(":")) {
            File file = new File(filename);
            if (!aFilter.accept(file.getParentFile(), file.getName()) || !file.isDirectory()) continue;
            list.add(file.getAbsolutePath());
        }
        return list.toArray(new String[list.size()]);
    }

    public static File[] getDirFiles(FilenameFilter aFilter) {
        ArrayList<File> list = new ArrayList<File>();
        for (String filename : System.getProperty(CLASSPATH).split(":")) {
            File file = new File(filename);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Checking to see if {} is a dir ({})", (Object)file.getAbsolutePath(), (Object)(file.isDirectory() ? "yes" : "no"));
            }
            if (!aFilter.accept(file.getParentFile(), file.getName()) || !file.isDirectory()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} is a directory", (Object)file.getAbsolutePath());
            }
            list.add(file);
        }
        return list.toArray(new File[list.size()]);
    }

    public static String[] getJars() {
        ArrayList<String> list = new ArrayList<String>();
        FileExtFileFilter filter = new FileExtFileFilter("jar");
        for (String part : System.getProperty(CLASSPATH).split(":")) {
            File file = new File(part);
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            list.add(file.getAbsolutePath());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getJars(FilenameFilter aFilter) {
        ArrayList<String> list = new ArrayList<String>();
        FileExtFileFilter filter = new FileExtFileFilter("jar");
        for (String part : System.getProperty(CLASSPATH).split(":")) {
            String name;
            File file = new File(part);
            File parent = file.getParentFile();
            if (!filter.accept(parent, name = file.getName()) || !aFilter.accept(parent, name)) continue;
            list.add(file.getAbsolutePath());
        }
        return list.toArray(new String[list.size()]);
    }

    public static JarFile[] getJarFiles() throws IOException {
        ArrayList<JarFile> list = new ArrayList<JarFile>();
        FileExtFileFilter filter = new FileExtFileFilter("jar");
        for (String part : System.getProperty(CLASSPATH).split(":")) {
            File file = new File(part);
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            list.add(new JarFile(file));
        }
        return list.toArray(new JarFile[list.size()]);
    }

    public static JarFile[] getJarFiles(FilenameFilter aFilter) throws IOException {
        ArrayList<JarFile> list = new ArrayList<JarFile>();
        FileExtFileFilter filter = new FileExtFileFilter("jar");
        for (String part : System.getProperty(CLASSPATH).split(":")) {
            String name;
            File file = new File(part);
            File parent = file.getParentFile();
            if (!filter.accept(parent, name = file.getName()) || !aFilter.accept(parent, name)) continue;
            list.add(new JarFile(file));
        }
        return list.toArray(new JarFile[list.size()]);
    }

    public static URL findFirst(String aFilename) throws IOException {
        FileExtFileFilter filter = new FileExtFileFilter("jar");
        for (String cpEntry : System.getProperty(CLASSPATH).split(":")) {
            File file = new File(cpEntry);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Checking {} for {}", (Object)cpEntry, (Object)aFilename);
            }
            if (file.isDirectory()) {
                File target = new File(file, aFilename);
                if (!target.exists()) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found {} in {}", (Object)aFilename, (Object)cpEntry);
                }
                return target.toURI().toURL();
            }
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            JarFile jarFile = new JarFile(file);
            JarEntry jarEntry = jarFile.getJarEntry(aFilename);
            if (jarEntry != null && jarEntry.getSize() > 0L) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found {} in {}", (Object)aFilename, (Object)cpEntry);
                }
                jarFile.close();
                return file.toURI().toURL();
            }
            jarFile.close();
        }
        return null;
    }

    public static boolean find(String aFileName) throws IOException {
        return ClasspathUtils.findFirst(aFileName) != null;
    }
}

