/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojos.flexbuilder;

import info.flexmojos.utilities.PathUtil;
import info.rvin.flexmojos.utilities.CompileConfigurationLoader;
import info.rvin.flexmojos.utilities.MavenUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseConfigFile;
import org.apache.maven.plugin.eclipse.EclipsePlugin;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.velocity.VelocityComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexbuilderMojo
extends EclipsePlugin {
    private static final String APPLICATION_NATURE = "com.adobe.flexbuilder.project.flexnature";
    private static final String LIBRARY_NATURE = "com.adobe.flexbuilder.project.flexlibnature";
    private static final String ACTIONSCRIPT_NATURE = "com.adobe.flexbuilder.project.actionscriptnature";
    private static final String FLEXBUILDER_BUILD_COMMAND = "com.adobe.flexbuilder.project.flexbuilder";
    protected static final String M2ECLIPSE_NATURE = "org.maven.ide.eclipse.maven2Nature";
    protected static final String M2ECLIPSE_BUILD_COMMAND = "org.maven.ide.eclipse.maven2Builder";
    private boolean enableM2e;
    private static final String SWC = "swc";
    private static final String SWF = "swf";
    private static final String RB_SWC = "rb.swc";
    private VelocityComponent velocityComponent;
    protected List remoteRepositories;
    protected ArtifactResolver resolver;

    protected void fillDefaultNatures(String packaging) {
        super.fillDefaultNatures(packaging);
        if (SWF.equals(packaging)) {
            this.getProjectnatures().add(APPLICATION_NATURE);
            this.getProjectnatures().add(ACTIONSCRIPT_NATURE);
        }
        if (SWC.equals(packaging)) {
            this.getProjectnatures().add(LIBRARY_NATURE);
            this.getProjectnatures().add(ACTIONSCRIPT_NATURE);
        }
        if (this.enableM2e) {
            this.getProjectnatures().add(M2ECLIPSE_NATURE);
        }
    }

    protected void fillDefaultBuilders(String packaging) {
        super.fillDefaultBuilders(packaging);
        if (SWF.equals(packaging) || SWC.equals(packaging)) {
            this.getBuildcommands().add(FLEXBUILDER_BUILD_COMMAND);
        }
        if (this.enableM2e) {
            this.getBuildcommands().add(M2ECLIPSE_BUILD_COMMAND);
        }
    }

    public void writeConfiguration(IdeDependency[] deps) throws MojoExecutionException {
        super.writeConfiguration(deps);
        String packaging = this.project.getPackaging();
        this.writeAsProperties(packaging);
        if (SWF.equals(packaging)) {
            this.writeFlexProperties();
        } else if (SWC.equals(packaging)) {
            this.writeFlexLibProperties();
        } else {
            throw new MojoExecutionException("Unexpected packaging " + packaging);
        }
    }

    private void writeFlexLibProperties() throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        this.runVelocity("/flexLibProperties.vm", ".flexLibProperties", context);
    }

    private void writeFlexProperties() throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        this.runVelocity("/flexProperties.vm", ".flexProperties", context);
    }

    protected Set<Artifact> getDependencyArtifacts() throws MojoExecutionException {
        ArtifactResolutionResult arr;
        try {
            arr = this.resolver.resolveTransitively(this.project.getDependencyArtifacts(), this.project.getArtifact(), this.remoteRepositories, this.localRepository, this.artifactMetadataSource);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        ArrayList<Artifact> dependencies = new ArrayList<Artifact>(arr.getArtifacts());
        List<Artifact> extraRbs = this.resolveResourceBundles(dependencies);
        HashSet<Artifact> result = new HashSet<Artifact>();
        result.addAll(dependencies);
        result.addAll(extraRbs);
        return result;
    }

    private List<Artifact> resolveResourceBundles(List<Artifact> dependencies) throws MojoExecutionException {
        ArrayList<Artifact> extraRbs = new ArrayList<Artifact>();
        String[] locales = this.getLocales();
        Iterator<Artifact> it = dependencies.iterator();
        while (it.hasNext()) {
            Artifact dependency = it.next();
            if ("playerglobal".equals(dependency.getArtifactId()) || "airglobal".equals(dependency.getArtifactId())) {
                it.remove();
                continue;
            }
            if (SWC.equals(dependency.getType())) continue;
            if (RB_SWC.equals(dependency.getType())) {
                for (String locale : locales) {
                    Artifact resolvedResourceBundle = this.artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), locale);
                    MavenUtils.resolveArtifact((Artifact)resolvedResourceBundle, (ArtifactResolver)this.resolver, (ArtifactRepository)this.localRepository, (List)this.remoteRepositories);
                    extraRbs.add(resolvedResourceBundle);
                }
                it.remove();
                continue;
            }
            it.remove();
        }
        return extraRbs;
    }

    private String[] getLocales() {
        Object[] locales = new String[]{};
        Object[] deprecatedLocales = CompileConfigurationLoader.getCompilerPluginSettings((MavenProject)this.project, (String)"locales");
        Object[] runtimeLocales = CompileConfigurationLoader.getCompilerPluginSettings((MavenProject)this.project, (String)"runtimeLocales");
        Object[] compiledLocales = CompileConfigurationLoader.getCompilerPluginSettings((MavenProject)this.project, (String)"compiledLocales");
        String defaultLocale = CompileConfigurationLoader.getCompilerPluginSetting((MavenProject)this.project, (String)"defaultLocale");
        locales = (String[])ArrayUtils.addAll((Object[])locales, (Object[])deprecatedLocales);
        locales = (String[])ArrayUtils.addAll((Object[])locales, (Object[])runtimeLocales);
        locales = (String[])ArrayUtils.addAll((Object[])locales, (Object[])compiledLocales);
        if (defaultLocale != null) {
            locales = (String[])ArrayUtils.add((Object[])locales, (Object)defaultLocale);
        }
        return locales;
    }

    private void writeAsProperties(String packaging) throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        context.put("dependencies", this.getDependencyArtifacts());
        context.put("locales", (Object)this.getPlainLocales());
        context.put("mainSources", (Object)this.getMainSources());
        if (SWF.equals(packaging)) {
            File sourceFile = MavenUtils.resolveSourceFile((MavenProject)this.project, (String)CompileConfigurationLoader.getCompilerPluginSetting((MavenProject)this.project, (String)"sourceFile"));
            context.put("mainApplication", (Object)sourceFile.getName());
        } else if (SWC.equals(packaging)) {
            context.put("mainApplication", (Object)(this.project.getArtifactId() + ".as"));
            context.put("includes", (Object)("-include-sources " + this.getPlainSources()));
        }
        context.put("sources", this.getRelativeSources());
        this.runVelocity("/actionScriptProperties.vm", ".actionScriptProperties", context);
    }

    private String getMainSources() {
        String mainSources = PathUtil.getRelativePath((File)this.project.getBasedir(), (File)new File(this.project.getBuild().getSourceDirectory()));
        return mainSources;
    }

    private String getPlainSources() {
        String[] sources = CompileConfigurationLoader.getCompilerPluginSettings((MavenProject)this.project, (String)"includeSources");
        if (sources == null) {
            sources = new String[]{this.project.getBuild().getSourceDirectory()};
        }
        return this.plain(sources);
    }

    private List<String> getRelativeSources() {
        ArrayList<String> sources = new ArrayList<String>();
        List<String> sourceRoots = this.getSourceRoots();
        for (String sourceRoot : sourceRoots) {
            File source = new File(sourceRoot);
            if (!source.exists()) continue;
            String relative = PathUtil.getRelativePath((File)this.project.getBasedir(), (File)source);
            sources.add(relative);
        }
        return sources;
    }

    private List<String> getSourceRoots() {
        ArrayList<String> sources = new ArrayList<String>();
        List sourceRoots = this.project.getExecutionProject() != null ? this.project.getExecutionProject().getCompileSourceRoots() : this.project.getCompileSourceRoots();
        sources.addAll(sourceRoots);
        List testRoots = this.project.getExecutionProject() != null ? this.project.getExecutionProject().getTestCompileSourceRoots() : this.project.getTestCompileSourceRoots();
        sources.addAll(testRoots);
        for (Resource resource : this.project.getBuild().getResources()) {
            sources.add(resource.getDirectory());
        }
        for (Resource resource : this.project.getBuild().getTestResources()) {
            sources.add(resource.getDirectory());
        }
        return sources;
    }

    private String getPlainLocales() {
        String[] locales = this.getLocales();
        String buf = this.plain(locales);
        return buf;
    }

    private String plain(String[] locales) {
        StringBuilder buf = new StringBuilder();
        for (String locale : locales) {
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append(locale);
        }
        return buf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runVelocity(String templateName, String fileName, VelocityContext context) throws MojoExecutionException {
        FileWriter writer = null;
        try {
            Template template = this.velocityComponent.getEngine().getTemplate(templateName);
            writer = new FileWriter(new File(this.project.getBasedir(), fileName));
            template.merge((Context)context, (Writer)writer);
            ((Writer)writer).flush();
            if (writer == null) return;
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Error writting " + fileName, e);
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return;
    }

    protected void setupExtras() throws MojoExecutionException {
        EclipseConfigFile utfConfig = new EclipseConfigFile();
        utfConfig.setName(".settings/org.eclipse.core.resources.prefs");
        utfConfig.setContent(this.getSettingsContent());
        try {
            Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)"additionalConfig", ((Object)((Object)this)).getClass());
            field.setAccessible(true);
            Object[] originalConfig = (EclipseConfigFile[])field.get((Object)this);
            Object[] configs = new EclipseConfigFile[]{utfConfig};
            configs = (EclipseConfigFile[])ArrayUtils.addAll((Object[])configs, (Object[])originalConfig);
            field.set((Object)this, configs);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error settings project to UTF-8", e);
        }
    }

    private String getSettingsContent() {
        StringBuilder sb = new StringBuilder();
        sb.append('#').append(new Date().toString()).append('\n');
        sb.append("eclipse.preferences.version=1").append('\n');
        sb.append("encoding/<project>=UTF-8").append('\n');
        return sb.toString();
    }
}

