/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojo.test;

import info.rvin.flexmojos.utilities.MavenUtils;
import info.rvin.mojo.flexmojo.compiler.ApplicationMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCompilerMojo
extends ApplicationMojo {
    private boolean skipTests;
    private File testRunnerTemplate;
    private String[] includeTestFiles;
    private String[] excludeTestFiles;
    private List<String> testClasses;
    private File testFolder;
    private int testPort;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Flex-mojos " + MavenUtils.getFlexMojosVersion() + " - GNU GPL License (NO WARRANTY) - See COPYRIGHT file"));
        this.testFolder = new File(this.build.getTestSourceDirectory());
        if (this.skipTests) {
            this.getLog().warn((CharSequence)"Skipping test phase.");
            return;
        }
        if (!this.testFolder.exists()) {
            this.getLog().warn((CharSequence)("Test folder not found" + this.testFolder));
            return;
        }
        this.setUp();
        if (this.testClasses == null || this.testClasses.isEmpty()) {
            this.getLog().warn((CharSequence)("No test classes found for pattern: " + Arrays.toString(this.includeTestFiles)));
        } else {
            this.run();
            this.tearDown();
        }
    }

    @Override
    public void setUp() throws MojoExecutionException, MojoFailureException {
        File testSourceFile;
        File outputFolder;
        this.isSetProjectFile = false;
        this.linkReport = false;
        this.loadExterns = null;
        if (this.includeTestFiles == null) {
            this.includeTestFiles = new String[]{"Test*.as", "*Test.as"};
        }
        if (!(outputFolder = new File(this.build.getTestOutputDirectory())).exists()) {
            outputFolder.mkdirs();
        }
        this.testClasses = this.getTestClasses();
        try {
            testSourceFile = this.generateTester(this.testClasses);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to generate tester class.", e);
        }
        this.sourceFile = null;
        this.source = testSourceFile;
        super.setUp();
    }

    private List<String> getTestClasses() {
        Collection testFiles = FileUtils.listFiles((File)this.testFolder, (IOFileFilter)new WildcardFileFilter(this.includeTestFiles), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        if (this.excludeTestFiles != null && this.excludeTestFiles.length > 0) {
            this.getLog().debug((CharSequence)("excludeTestFiles: " + Arrays.asList(this.excludeTestFiles)));
            Collection excludedTestFiles = FileUtils.listFiles((File)this.testFolder, (IOFileFilter)new WildcardFileFilter(this.excludeTestFiles), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
            testFiles.removeAll(excludedTestFiles);
        }
        ArrayList<String> testClasses = new ArrayList<String>();
        int trimPoint = this.testFolder.getAbsolutePath().length() + 1;
        for (File testFile : testFiles) {
            String testClass = testFile.getAbsolutePath();
            int endPoint = testClass.lastIndexOf(46);
            testClass = testClass.substring(trimPoint, endPoint);
            testClass = testClass.replace('/', '.');
            testClass = testClass.replace('\\', '.');
            testClasses.add(testClass);
        }
        this.getLog().debug((CharSequence)("testClasses: " + testClasses));
        return testClasses;
    }

    private File generateTester(List<String> testClasses) throws Exception {
        StringBuilder imports = new StringBuilder();
        for (String testClass : testClasses) {
            imports.append("import ");
            imports.append(testClass);
            imports.append(";");
            imports.append('\n');
        }
        StringBuilder classes = new StringBuilder();
        for (String testClass : testClasses) {
            testClass = testClass.substring(testClass.lastIndexOf(46) + 1);
            classes.append("addTest( ");
            classes.append(testClass);
            classes.append(");");
            classes.append('\n');
        }
        InputStream templateSource = this.getTemplate();
        String sourceString = IOUtils.toString((InputStream)templateSource);
        sourceString = sourceString.replace("$imports", imports);
        sourceString = sourceString.replace("$testClasses", classes);
        sourceString = sourceString.replace("$port", String.valueOf(this.testPort));
        File testSourceFile = new File(this.build.getTestOutputDirectory(), "TestRunner.mxml");
        FileWriter fileWriter = new FileWriter(testSourceFile);
        IOUtils.write((String)sourceString, (Writer)fileWriter);
        fileWriter.flush();
        fileWriter.close();
        return testSourceFile;
    }

    private InputStream getTemplate() throws MojoExecutionException {
        if (this.testRunnerTemplate == null) {
            return ((Object)((Object)this)).getClass().getResourceAsStream("/test/TestRunner.vm");
        }
        if (!this.testRunnerTemplate.exists()) {
            throw new MojoExecutionException("Template file not found: " + this.testRunnerTemplate);
        }
        try {
            return new FileInputStream(this.testRunnerTemplate);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Error reading template file", (Exception)e);
        }
    }

    @Override
    protected void configure() throws MojoExecutionException, MojoFailureException {
        this.compiledLocales = this.getLocales();
        this.runtimeLocales = null;
        super.configure();
        this.configuration.addSourcePath(new File[]{new File(this.build.getTestOutputDirectory())});
        this.configuration.addSourcePath(this.getValidSourceRoots(this.project.getTestCompileSourceRoots()).toArray(new File[0]));
        this.configuration.allowSourcePathOverlap(true);
        this.configuration.enableDebugging(true, this.debugPassword);
    }

    @Override
    protected void resolveDependencies() throws MojoExecutionException, MojoFailureException {
        this.configuration.setExternalLibraryPath(this.getGlobalDependency());
        this.configuration.setLibraryPath(this.getDependenciesPath("compile"));
        this.configuration.addLibraryPath(this.getDependenciesPath("merged"));
        this.configuration.addLibraryPath(this.merge(this.getResourcesBundles(this.getDefaultLocale()), this.getResourcesBundles(this.runtimeLocales), this.getResourcesBundles(this.compiledLocales)));
        this.configuration.includeLibraries(this.merge(this.getDependenciesPath("internal"), this.getDependenciesPath("test"), this.getDependenciesPath("rsl"), this.getDependenciesPath("caching"), this.getDependenciesPath("external")));
        this.configuration.setTheme(this.getThemes());
    }

    private String[] getLocales() {
        if (this.runtimeLocales == null && this.compiledLocales == null) {
            return new String[]{this.getDefaultLocale()};
        }
        LinkedHashSet locales = new LinkedHashSet();
        if (this.runtimeLocales != null) {
            locales.addAll(Arrays.asList(this.runtimeLocales));
        }
        if (this.compiledLocales != null) {
            locales.addAll(Arrays.asList(this.compiledLocales));
        }
        return locales.toArray(new String[0]);
    }

    private File[] merge(File[] ... filesSets) {
        ArrayList files = new ArrayList();
        File[][] fileArray = filesSets;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File[] fileSet = fileArray[n];
            files.addAll(Arrays.asList(fileSet));
            ++n;
        }
        return files.toArray(new File[0]);
    }

    @Override
    protected File getOutput() {
        return new File(this.build.getTestOutputDirectory(), "TestRunner.swf");
    }

    @Override
    protected void compileModules() throws MojoFailureException, MojoExecutionException {
    }
}

