/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojos.asdoc;

import info.rvin.flexmojos.asdoc.AsDocMojo;
import info.rvin.flexmojos.utilities.MavenUtils;
import java.io.File;
import java.util.Locale;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;

public class AsDocReport
extends AsDocMojo
implements MavenReport {
    private Renderer siteRenderer;
    private String destDir;
    private String name;
    private String description;
    protected File reportOutputDirectory;

    public boolean canGenerateReport() {
        return true;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Flex-mojos " + MavenUtils.getFlexMojosVersion() + " - GNU GPL License (NO WARRANTY) - See COPYRIGHT file"));
        try {
            SiteRendererSink sink = this.siteRenderer.createSink(this.getReportOutputDirectory(), this.getOutputName() + ".html");
            this.generate((Sink)sink, Locale.getDefault());
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation:" + e.getMessage(), e);
        }
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.output = this.getReportOutputDirectory();
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader savedCL = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            super.execute();
            currentThread.setContextClassLoader(savedCL);
        }
        catch (Exception e) {
            throw new MavenReportException("Unable to generate report", e);
        }
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        return this.description;
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public String getOutputName() {
        return this.destDir + "/index";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.output;
        }
        return this.reportOutputDirectory;
    }

    public boolean isExternalReport() {
        return true;
    }

    public void setReportOutputDirectory(File outputDirectory) {
        this.reportOutputDirectory = outputDirectory != null && !outputDirectory.getAbsolutePath().endsWith(this.destDir) ? new File(outputDirectory, this.destDir) : outputDirectory;
    }
}

