/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojos.asdoc;

import eu.cedarsoft.utils.ZipExtractor;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.ASDoc;
import info.flexmojos.utilities.Namespace;
import info.rvin.flexmojos.utilities.CompileConfigurationLoader;
import info.rvin.flexmojos.utilities.MavenUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsDocMojo
extends AbstractMojo {
    protected MavenProject project;
    protected Build build;
    protected MavenProjectHelper projectHelper;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver resolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactRepository localRepository;
    protected List remoteRepositories;
    private List<Artifact> pluginArtifacts;
    private String[] docClasses;
    private Namespace[] docNamespaces;
    private Namespace[] namespaces;
    private File[] docSources;
    private String[] excludeClasses;
    private boolean excludeDependencies;
    private String footer;
    private int leftFramesetWidth;
    private String mainTitle;
    protected File output;
    private Map<String, String> packageDescriptions;
    private File templatesPath;
    private String windowTitle;
    private List<File> libraries;
    private File configFile;
    private File fontsSnapshot;
    private String compatibilityVersion;
    protected File[] sourcePaths;
    private boolean headlessServer;
    private Set<Artifact> dependencyArtifacts;

    protected void setUp() throws MojoExecutionException, MojoFailureException {
        URL url;
        if (this.sourcePaths == null) {
            List sourceRoots = this.project.getCompileSourceRoots();
            ArrayList<File> sources = new ArrayList<File>();
            for (String sourceRoot : sourceRoots) {
                File source = new File(sourceRoot);
                if (!source.exists()) continue;
                sources.add(source);
            }
            this.sourcePaths = sources.toArray(new File[sources.size()]);
        }
        if (this.docSources == null && this.docClasses == null && this.docNamespaces == null) {
            this.getLog().warn((CharSequence)"Nothing expecified to include.  Assuming source paths.");
            this.docSources = this.sourcePaths;
        }
        this.libraries = new ArrayList<File>();
        for (Artifact artifact : this.getDependencyArtifacts()) {
            if (!"swc".equals(artifact.getType())) continue;
            this.libraries.add(artifact.getFile());
        }
        if (this.output == null) {
            this.output = new File(this.build.getDirectory(), "asdoc");
            if (!this.output.exists()) {
                this.output.mkdirs();
            }
        }
        if (this.configFile == null) {
            List resources = this.build.getResources();
            for (Resource resource : resources) {
                File cfg = new File(resource.getDirectory(), this.getConfigFileName());
                if (!cfg.exists()) continue;
                this.configFile = cfg;
                break;
            }
        }
        if (this.configFile == null) {
            url = ((Object)((Object)this)).getClass().getResource("/configs/" + this.getConfigFileName());
            this.configFile = new File(this.build.getDirectory(), this.getConfigFileName());
            try {
                FileUtils.copyURLToFile((URL)url, (File)this.configFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating config.xml");
            }
        }
        if (!this.configFile.exists()) {
            throw new MojoExecutionException("Unable to find " + this.configFile);
        }
        if (this.fontsSnapshot == null) {
            url = MavenUtils.isMac() ? ((Object)((Object)this)).getClass().getResource("/fonts/macFonts.ser") : ((Object)((Object)this)).getClass().getResource("/fonts/winFonts.ser");
            File fontsSer = new File(this.build.getDirectory(), "fonts.ser");
            try {
                FileUtils.copyURLToFile((URL)url, (File)fontsSer);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating fonts.ser");
            }
            this.fontsSnapshot = fontsSer;
        }
        if (this.templatesPath == null) {
            this.templatesPath = this.generateDefaultTemplate();
        }
        List fdkNamespaces = MavenUtils.getFdkNamespaces(this.getDependencyArtifacts(), (Build)this.build);
        if (this.namespaces != null) {
            fdkNamespaces.addAll(Arrays.asList(this.namespaces));
        }
        this.namespaces = fdkNamespaces.toArray(new Namespace[0]);
    }

    private File generateDefaultTemplate() throws MojoExecutionException {
        File templates = new File(this.build.getDirectory(), "templates");
        templates.mkdirs();
        for (Artifact artifact : this.pluginArtifacts) {
            if (!"template".equals(artifact.getClassifier())) continue;
            try {
                ZipExtractor ze = new ZipExtractor(artifact.getFile());
                ze.extract(templates);
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error happens when trying to extract AsDoc Template.", (Exception)e);
            }
            this.makeHelperExecutable(templates);
            return templates;
        }
        throw new MojoExecutionException("Unable to generate default template.");
    }

    private void makeHelperExecutable(File templates) throws MojoExecutionException {
        if (!MavenUtils.isWindows()) {
            Runtime runtime = Runtime.getRuntime();
            String pathname = String.format("%s/%s", templates.getAbsolutePath(), "asDocHelper" + (MavenUtils.isLinux() ? ".linux" : ""));
            String[] statements = new String[]{"chmod", "u+x", pathname};
            try {
                Process p = runtime.exec(statements);
                int result = p.waitFor();
                if (0 != result) {
                    throw new MojoExecutionException(String.format("Unable to execute %s. Return value = %d", Arrays.asList(statements), result));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException(String.format("Unable to execute %s", Arrays.asList(statements)));
            }
        }
    }

    private String getConfigFileName() {
        return "config.xml";
    }

    protected void run() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> args = new ArrayList<String>();
        this.addNamespaces(args);
        this.addDocSources(args);
        this.addDocClasses(args);
        this.addDocNamespaces(args);
        this.addSourcePath(args);
        this.addLibraries(args);
        this.addCompatibility(args);
        this.addPackageDescriptions(args);
        this.addDefines(args);
        this.addExcludeClasses(args);
        this.addFooter(args);
        args.add("-templates-path=" + this.templatesPath.getAbsolutePath());
        args.add("-window-title=" + this.windowTitle);
        args.add("-main-title=" + this.mainTitle);
        args.add("-left-frameset-width=" + this.leftFramesetWidth);
        args.add("-exclude-dependencies=" + this.excludeDependencies);
        args.add("-compiler.fonts.local-fonts-snapshot=" + this.fontsSnapshot.getAbsolutePath());
        if (this.headlessServer) {
            args.add("-compiler.headless-server=true");
        }
        args.add("-load-config=" + this.configFile.getAbsolutePath());
        args.add("-output=" + this.output.getAbsolutePath());
        this.getLog().info((CharSequence)((Object)args).toString());
        ASDoc.asdoc((String[])args.toArray(new String[args.size()]));
        int errorCount = ThreadLocalToolkit.errorCount();
        if (errorCount > 0) {
            throw new MojoExecutionException("Error compiling!");
        }
    }

    private void addDocNamespaces(List<String> args) {
        if (this.docNamespaces == null || this.docNamespaces.length == 0) {
            return;
        }
        for (Namespace namespace : this.docNamespaces) {
            args.add("-compiler.namespaces.namespace");
            args.add(namespace.getUri());
            args.add(namespace.getManifest().getAbsolutePath());
        }
        StringBuilder sb = new StringBuilder();
        for (Namespace namespace : this.docNamespaces) {
            if (sb.length() == 0) {
                sb.append("-doc-namespaces=");
            } else {
                sb.append(',');
            }
            sb.append(namespace.getUri());
        }
        args.add(sb.toString());
    }

    private void addDocClasses(List<String> args) {
        if (this.docClasses == null || this.docClasses.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String docClass : this.docClasses) {
            if (sb.length() == 0) {
                sb.append("-doc-classes=");
            } else {
                sb.append(',');
            }
            sb.append(docClass);
        }
        args.add(sb.toString());
    }

    private void addExcludeClasses(List<String> args) {
        if (this.excludeClasses == null || this.excludeClasses.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String excludeClass : this.excludeClasses) {
            if (sb.length() == 0) {
                sb.append("-exclude-classes=");
            } else {
                sb.append(',');
            }
            sb.append(excludeClass);
        }
        args.add(sb.toString());
    }

    private void addFooter(List<String> args) {
        if (this.footer != null) {
            args.add("-footer");
            args.add(this.footer);
        }
    }

    private void addPackageDescriptions(List<String> args) {
        if (this.packageDescriptions == null) {
            return;
        }
        for (String pack : this.packageDescriptions.keySet()) {
            args.add("-packages.package");
            args.add(pack);
            args.add(this.packageDescriptions.get(pack));
        }
    }

    private void addDefines(List<String> args) {
        Xpp3Dom defines = CompileConfigurationLoader.getCompilerPluginConfiguration((MavenProject)this.project, (String)"defines");
        if (defines == null || defines.getChildren() == null || defines.getChildren().length == 0) {
            return;
        }
        for (Xpp3Dom define : defines.getChildren()) {
            args.add("-compiler.define+=" + define.getName() + "," + define.getValue());
        }
    }

    private void addCompatibility(List<String> args) {
        if (this.compatibilityVersion != null) {
            args.add("-compiler.mxml.compatibility-version=" + this.compatibilityVersion);
        }
    }

    private void addLibraries(List<String> args) {
        if (this.libraries == null || this.libraries.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (File lib : this.libraries) {
            if (sb.length() == 0) {
                sb.append("-library-path=");
            } else {
                sb.append(',');
            }
            sb.append(lib.getAbsolutePath());
        }
        args.add(sb.toString());
    }

    private void addSourcePath(List<String> args) {
        if (this.sourcePaths == null || this.sourcePaths.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (File path : this.sourcePaths) {
            if (sb.length() == 0) {
                sb.append("-source-path=");
            } else {
                sb.append(',');
            }
            sb.append(path.getAbsolutePath());
        }
        args.add(sb.toString());
    }

    private void addDocSources(List<String> args) {
        if (this.docSources == null || this.docSources.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (File docs : this.docSources) {
            if (sb.length() == 0) {
                sb.append("-doc-sources=");
            } else {
                sb.append(',');
            }
            sb.append(docs.getAbsolutePath());
        }
        args.add(sb.toString());
    }

    private void addNamespaces(List<String> args) {
        if (this.namespaces == null || this.namespaces.length == 0) {
            return;
        }
        for (Namespace namespace : this.namespaces) {
            args.add("-compiler.namespaces.namespace");
            args.add(namespace.getUri());
            args.add(namespace.getManifest().getAbsolutePath());
        }
    }

    protected void tearDown() throws MojoExecutionException, MojoFailureException {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Flex-mojos " + MavenUtils.getFlexMojosVersion() + " - GNU GPL License (NO WARRANTY) - See COPYRIGHT file"));
        this.setUp();
        this.run();
        this.tearDown();
    }

    protected Set<Artifact> getDependencyArtifacts() throws MojoExecutionException {
        if (this.dependencyArtifacts == null) {
            this.dependencyArtifacts = MavenUtils.getDependencyArtifacts((MavenProject)this.project, (ArtifactResolver)this.resolver, (ArtifactRepository)this.localRepository, (List)this.remoteRepositories, (ArtifactMetadataSource)this.artifactMetadataSource);
        }
        return this.dependencyArtifacts;
    }
}

