/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.interfaces.NormalizedStringDistance;

public class NGram
implements NormalizedStringDistance {
    private final int n;

    public NGram(int n) {
        this.n = n;
    }

    public NGram() {
        this.n = 2;
    }

    public double distance(String s0, String s1) {
        int i;
        int special = 10;
        int sl = s0.length();
        int tl = s1.length();
        if (sl == 0 || tl == 0) {
            if (sl == tl) {
                return 1.0;
            }
            return 0.0;
        }
        int cost = 0;
        if (sl < this.n || tl < this.n) {
            int ni = Math.min(sl, tl);
            for (int i2 = 0; i2 < ni; ++i2) {
                if (s0.charAt(i2) != s1.charAt(i2)) continue;
                ++cost;
            }
            return (float)cost / (float)Math.max(sl, tl);
        }
        char[] sa = new char[sl + this.n - 1];
        for (i = 0; i < sa.length; ++i) {
            sa[i] = i < this.n - 1 ? 10 : s0.charAt(i - this.n + 1);
        }
        float[] p = new float[sl + 1];
        float[] d = new float[sl + 1];
        char[] t_j = new char[this.n];
        for (i = 0; i <= sl; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= tl; ++j) {
            if (j < this.n) {
                int ti;
                for (ti = 0; ti < this.n - j; ++ti) {
                    t_j[ti] = 10;
                }
                for (ti = this.n - j; ti < this.n; ++ti) {
                    t_j[ti] = s1.charAt(ti - (this.n - j));
                }
            } else {
                t_j = s1.substring(j - this.n, j).toCharArray();
            }
            d[0] = j;
            for (i = 1; i <= sl; ++i) {
                cost = 0;
                int tn = this.n;
                for (int ni = 0; ni < this.n; ++ni) {
                    if (sa[i - 1 + ni] != t_j[ni]) {
                        ++cost;
                        continue;
                    }
                    if (sa[i - 1 + ni] != '\n') continue;
                    --tn;
                }
                float ec = (float)cost / (float)tn;
                d[i] = Math.min(Math.min(d[i - 1] + 1.0f, p[i] + 1.0f), p[i - 1] + ec);
            }
            float[] _d = p;
            p = d;
            d = _d;
        }
        return 1.0 - (double)(p[sl] / (float)Math.max(tl, sl));
    }
}

