/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.aggregation;

import info.debatty.java.aggregation.InterpolationFunctions;
import info.debatty.java.aggregation.Point;

class Vector {
    private final double[] values;

    Vector(int size) {
        this.values = new double[size];
    }

    Vector(double[] values) {
        this.values = new double[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
    }

    Vector(Vector a) {
        this(a.values);
    }

    public double get(int position) {
        return this.values[position];
    }

    public void set(int position, double value) {
        this.values[position] = value;
    }

    public InterpolationFunctions getInterpolationFunctions() {
        Point[] points = new Point[this.values.length + 1];
        points[0] = new Point();
        for (int i = 1; i <= this.values.length; ++i) {
            points[i] = new Point(1.0 * (double)i / (double)this.values.length, this.values[i - 1] + points[i - 1].y);
        }
        return new InterpolationFunctions(points);
    }

    public Vector sort() {
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = i + 1; j < this.values.length; ++j) {
                if (!(this.values[j] > this.values[i])) continue;
                double temp = this.values[j];
                this.values[j] = this.values[i];
                this.values[i] = temp;
            }
        }
        return this;
    }

    public Vector sort(Vector other) {
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = i + 1; j < this.values.length; ++j) {
                if (!(this.values[j] > this.values[i])) continue;
                double temp = other.values[j];
                other.values[j] = other.values[i];
                other.values[i] = temp;
                double temp2 = this.values[j];
                this.values[j] = this.values[i];
                this.values[i] = temp2;
            }
        }
        return this;
    }

    public double dotProduct(Vector other) {
        double agg = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            agg += other.values[i] * this.values[i];
        }
        return agg;
    }

    int size() {
        return this.values.length;
    }
}

