/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.aggregation;

class Point {
    double x = 0.0;
    double y = 0.0;

    Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    Point() {
    }

    Point(Point other) {
        this.x = other.x;
        this.y = other.y;
    }

    static double bernsteinInterpolation2(Point p0, Point p1, Point p2, double x) {
        double x0 = p0.x;
        double y0 = p0.y;
        double y1 = p1.y;
        double x2 = p2.x;
        double y2 = p2.y;
        if (x2 == x0) {
            return y0;
        }
        double y = y0 * (x2 - x) * (x2 - x) + y1 * 2.0 * (x - x0) * (x2 - x) + y2 * (x - x0) * (x - x0);
        return y / ((x2 - x0) * (x2 - x0));
    }

    public static double computeCoef(Point p1, Point p2) {
        return (p2.y - p1.y) / (p2.x - p1.x);
    }

    public static double computeLineCoef(double coef0, double coef1, Point p1, Point p0, Point p2) {
        assert (coef0 * coef1 >= 0.0);
        if (Math.abs(coef0) > Math.abs(coef1)) {
            double delta_y = p2.y - p1.y;
            double bx = delta_y / coef0 + p1.x;
            double cx = (bx + p2.x) / 2.0;
            return delta_y / (cx - p1.x);
        }
        if (Math.abs(coef0) < Math.abs(coef1)) {
            double delta_y = p1.y - p0.y;
            double bx = p1.x - delta_y / coef1;
            double cx = (bx + p0.x) / 2.0;
            return delta_y / (p1.x - cx);
        }
        return coef0;
    }
}

