/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter;

import gherkin.formatter.Filter;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Range;
import gherkin.formatter.model.Tag;
import java.util.ArrayList;
import java.util.List;

public class LineFilter
implements Filter {
    private final List<Long> lines;

    public LineFilter(List<Long> lines) {
        this.lines = lines;
    }

    @Override
    public boolean eval(List<Tag> tags, List<String> names, List<Range> ranges) {
        for (Range range : ranges) {
            if (range == null) continue;
            for (Long line : this.lines) {
                if (!range.isInclude(line)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ExamplesTableRow> filterTableBodyRows(List<ExamplesTableRow> exampleRows) {
        ArrayList<ExamplesTableRow> result = new ArrayList<ExamplesTableRow>();
        for (ExamplesTableRow row : exampleRows) {
            if (result.isEmpty()) {
                result.add(row);
                continue;
            }
            for (Long line : this.lines) {
                if ((long)row.getLine() != line) continue;
                result.add(row);
            }
        }
        return result;
    }
}

