/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro;

import cucumber.pro.results.GroupGenerator;
import cucumber.pro.results.MetadataApi;
import cucumber.pro.results.NullMetadataClient;
import cucumber.pro.results.Response;
import cucumber.pro.results.Status;
import cucumber.pro.results.WebSocketMetadataClient;
import cucumber.pro.scm.WorkingCopy;
import cucumber.pro.scm.WorkingCopyDetector;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import javax.websocket.DeploymentException;

public class CucumberProFormatter
implements Formatter,
Reporter {
    private static Env ENV = new Env("cucumber");
    private final MetadataApi metadataApi;
    private final WorkingCopy workingCopy;
    private final GroupGenerator groupGenerator;
    private List<Step> steps = new ArrayList<Step>();
    private BasicStatement statement;
    private String uri;
    private boolean headerSent;
    private List<Status> statuses = new ArrayList<Status>();
    private Future<Response> responseFuture;
    private int currentLine;

    private static boolean shouldPublish() {
        String[] ciVariables;
        for (String ciVariable : ciVariables = ENV.get("CUCUMBER_PRO_CI_VARIABLE", "BUILD_NUMBER,CI").split(",")) {
            String val = ENV.get(ciVariable);
            if (!Boolean.parseBoolean(val)) continue;
            return true;
        }
        return false;
    }

    private static URI resultsUri() throws URISyntaxException {
        return new URI(ENV.get("CUCUMBER_PRO_RESULTS_URL", "wss://results.cucumber.pro/ws"));
    }

    private static String getToken() {
        String token = ENV.get("CUCUMBER_PRO_TOKEN");
        if (token == null) {
            throw new CucumberException("Please define CUCUMBER_PRO_TOKEN");
        }
        return token;
    }

    private static MetadataApi createMetadataApi() throws URISyntaxException, IOException, DeploymentException {
        if (CucumberProFormatter.shouldPublish()) {
            return new WebSocketMetadataClient(new URI(CucumberProFormatter.resultsUri().toString() + "?token=" + CucumberProFormatter.getToken()));
        }
        return new NullMetadataClient();
    }

    public CucumberProFormatter() throws Exception {
        this(CucumberProFormatter.createMetadataApi(), WorkingCopyDetector.detect(), GroupGenerator.DEFAULT);
    }

    CucumberProFormatter(MetadataApi metadataApi, WorkingCopy workingCopy, GroupGenerator groupGenerator) {
        this.metadataApi = metadataApi;
        this.workingCopy = workingCopy;
        this.groupGenerator = groupGenerator;
        if (CucumberProFormatter.shouldPublish()) {
            workingCopy.checkClean();
        }
    }

    public void before(Match match, Result result) {
    }

    public void result(Result result) {
        this.publishResult(result, (BasicStatement)this.steps.remove(0));
    }

    public void after(Match match, Result result) {
        this.publishResult(result, this.statement);
    }

    private void publishResult(Result result, BasicStatement stmt) {
        Status status = this.getStatus(result);
        this.statuses.add(status);
        this.awaitPreviousFuture();
        this.responseFuture = this.metadataApi.sendTestStepResult(this.uri, stmt.getLine() + 1, status);
        String errorMessage = result.getErrorMessage();
        if (errorMessage != null) {
            this.awaitPreviousFuture();
            this.responseFuture = this.metadataApi.sendStackTrace(this.uri, stmt.getLine() + 1, errorMessage);
        }
    }

    private void awaitPreviousFuture() {
        if (this.responseFuture != null) {
            Response response = null;
            try {
                response = this.responseFuture.get();
                RuntimeException e = response.getException();
                if (e != null) {
                    throw e;
                }
            }
            catch (Exception e) {
                throw new CucumberException((Throwable)e);
            }
        }
    }

    public void match(Match match) {
    }

    public void embedding(String mimeType, byte[] bytes) {
        this.awaitPreviousFuture();
        this.responseFuture = this.metadataApi.sendMetadata(this.uri, this.currentLine + 1, mimeType);
        this.awaitPreviousFuture();
        this.responseFuture = this.metadataApi.sendBinary(bytes);
    }

    public void write(String text) {
    }

    public void uri(String uri) {
        this.uri = uri;
    }

    public void feature(Feature feature) {
        if (!this.headerSent) {
            this.metadataApi.sendHeader(this.workingCopy.getRepoUrl(), this.workingCopy.getRev(), this.workingCopy.getBranch(), this.groupGenerator.group());
            this.headerSent = true;
        }
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
        this.statement = scenario;
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.statuses.clear();
    }

    public void step(Step step) {
        this.currentLine = step.getLine();
        this.steps.add(step);
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        this.awaitPreviousFuture();
        this.responseFuture = this.metadataApi.sendTestCaseResult(this.uri, scenario.getLine() + 1, this.getStatus());
    }

    private Status getStatus() {
        int pos = 0;
        for (Status status : this.statuses) {
            int p = Arrays.binarySearch((Object[])Status.values(), (Object)status);
            pos = Math.max(pos, p);
        }
        return Status.values()[pos];
    }

    private Status getStatus(Result result) {
        return Status.valueOf(result.getStatus());
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void done() {
    }

    public void close() {
    }
}

