/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro.results;

import cucumber.pro.results.Header;
import cucumber.pro.results.JsonDecoder;
import cucumber.pro.results.JsonEncoder;
import cucumber.pro.results.MetadataApi;
import cucumber.pro.results.Response;
import cucumber.pro.results.Status;
import cucumber.pro.results.metadata.Metadata;
import cucumber.pro.results.metadata.StackTrace;
import cucumber.pro.results.metadata.TestCaseResult;
import cucumber.pro.results.metadata.TestStepResult;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.websocket.ClientEndpoint;
import javax.websocket.DeploymentException;
import javax.websocket.OnMessage;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.core.HandshakeException;

@ClientEndpoint(encoders={JsonEncoder.class}, decoders={JsonDecoder.class})
public class WebSocketMetadataClient
implements MetadataApi {
    private static final long TIMEOUT_MILLIS = 15000L;
    private final Future<Session> sessionFuture;
    private final BlockingQueue<Response> responseQueue = new SynchronousQueue<Response>();
    private final URI uri;

    public WebSocketMetadataClient(URI uri) throws URISyntaxException, IOException, DeploymentException {
        this.uri = uri;
        ClientManager client = ClientManager.createClient();
        this.sessionFuture = client.asyncConnectToServer((Object)this, uri);
    }

    @Override
    public Future<Response> sendHeader(String repoUrl, String rev, String branch, String group) {
        this.getEndpoint().sendObject((Object)new Header(repoUrl, rev, branch, group));
        return new ResponseFuture();
    }

    @Override
    public Future<Response> sendTestStepResult(String path, int location, Status status) {
        this.getEndpoint().sendObject((Object)new TestStepResult(path, location, status));
        return new ResponseFuture();
    }

    @Override
    public Future<Response> sendTestCaseResult(String path, int location, Status status) {
        this.getEndpoint().sendObject((Object)new TestCaseResult(path, location, status));
        return new ResponseFuture();
    }

    @Override
    public Future<Response> sendStackTrace(String path, int location, String stackTrace) {
        this.getEndpoint().sendObject((Object)new StackTrace(path, location, stackTrace));
        return new ResponseFuture();
    }

    @Override
    public Future<Response> sendMetadata(String path, int location, String mimeType) {
        this.getEndpoint().sendObject((Object)new Metadata(path, location, mimeType));
        return new ResponseFuture();
    }

    @Override
    public Future<Response> sendBinary(byte[] attachment) {
        this.getEndpoint().sendBinary(ByteBuffer.wrap(attachment));
        return new ResponseFuture();
    }

    private RemoteEndpoint.Async getEndpoint() {
        try {
            Session session = this.sessionFuture.get(15000L, TimeUnit.MILLISECONDS);
            if (session == null) {
                throw new RuntimeException("Couldn't connect to " + this.uri);
            }
            return session.getAsyncRemote();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DeploymentException) {
                DeploymentException de = (DeploymentException)e.getCause();
                if (de.getCause() instanceof HandshakeException) {
                    HandshakeException he = (HandshakeException)de.getCause();
                    if (he.getMessage().contains("401")) {
                        throw new RuntimeException("Couldn't authenticate user: " + this.uri.getQuery());
                    }
                    if (he.getMessage().contains("403")) {
                        throw new RuntimeException("Access denied: " + this.uri.getQuery());
                    }
                    throw he;
                }
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @OnMessage
    public void onMessage(Response response) throws InterruptedException {
        this.responseQueue.put(response);
    }

    private class ResponseFuture
    implements Future<Response> {
        private ResponseFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCancelled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDone() {
            return !WebSocketMetadataClient.this.responseQueue.isEmpty();
        }

        @Override
        public Response get() throws InterruptedException, ExecutionException {
            return (Response)WebSocketMetadataClient.this.responseQueue.take();
        }

        @Override
        public Response get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (Response)WebSocketMetadataClient.this.responseQueue.poll(timeout, unit);
        }
    }
}

