package cucumber.pro.results;

import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class NullMetadataClient implements MetadataApi {
    @Override
    public Future<Response> sendHeader(String repoUrl, String rev, String branch, String group) {
        return immediateFuture();
    }

    @Override
    public Future<Response> sendTestStepResult(String path, int location, Status status) {
        return immediateFuture();
    }

    @Override
    public Future<Response> sendTestCaseResult(String path, int location, Status status) {
        return immediateFuture();
    }

    @Override
    public Future<Response> sendStackTrace(String path, int location, String stackTrace) {
        return immediateFuture();
    }

    @Override
    public Future<Response> sendMetadata(String path, int location, String mimeType) {
        return immediateFuture();
    }

    @Override
    public Future<Response> sendBinary(byte[] attachment) {
        return immediateFuture();
    }

    private Future<Response> immediateFuture() {
        return new Future<Response>() {
            public boolean cancelled;

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancelled = true;
                return true;
            }

            @Override
            public boolean isCancelled() {
                return cancelled;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public Response get() throws InterruptedException, ExecutionException {
                return new Response(new HashMap<String,String>());
            }

            @Override
            public Response get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return get();
            }
        };
    }

}
