/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro.scm;

import cucumber.pro.scm.Exec;
import cucumber.pro.scm.WorkingCopy;
import java.io.File;
import java.util.List;

public class Svn
implements WorkingCopy {
    private final File rootDir;
    private final Exec exec;

    public static Svn detect(File dir) {
        File workingCopyRoot = null;
        while (dir != null) {
            File dotSvn = new File(dir, ".svn");
            if (dotSvn.isDirectory()) {
                workingCopyRoot = dir;
            }
            dir = dir.getParentFile();
        }
        return workingCopyRoot != null ? new Svn(workingCopyRoot) : null;
    }

    public Svn(File rootDir) {
        this.rootDir = rootDir;
        this.exec = new Exec(rootDir);
    }

    @Override
    public String getRevision() {
        List<String> stdout = this.exec.cmd("svn info");
        for (String line : stdout) {
            if (!line.startsWith("Revision: ")) continue;
            return line.substring("Revision: ".length());
        }
        throw new RuntimeException("Couldn't detect revision");
    }

    @Override
    public String getRepoUrl() {
        List<String> stdout = this.exec.cmd("svn info");
        for (String line : stdout) {
            if (!line.startsWith("URL: ")) continue;
            return line.substring("URL: ".length());
        }
        throw new RuntimeException("Couldn't detect revision");
    }

    @Override
    public String getBranch() {
        String url = null;
        String repositoryRoot = null;
        List<String> stdout = this.exec.cmd("svn info");
        for (String line : stdout) {
            if (line.startsWith("URL: ")) {
                url = line.substring("URL: ".length());
            }
            if (!line.startsWith("Repository Root: ")) continue;
            repositoryRoot = line.substring("Repository Root: ".length());
        }
        if (url == null) {
            throw new RuntimeException("No URL found");
        }
        if (repositoryRoot == null) {
            throw new RuntimeException("No Repository Root found");
        }
        return url.substring(repositoryRoot.length() + 1);
    }

    File getRootDir() {
        return this.rootDir;
    }
}

