/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro.scm;

import cucumber.pro.scm.Exec;
import cucumber.pro.scm.WorkingCopy;
import java.io.File;
import java.util.List;

public class Git
implements WorkingCopy {
    private final File rootDir;
    private final Exec exec;

    public static Git detect(File dir) {
        File workingCopyRoot = null;
        while (dir != null) {
            File dotSvn = new File(dir, ".git");
            if (dotSvn.isDirectory()) {
                workingCopyRoot = dir;
            }
            dir = dir.getParentFile();
        }
        return workingCopyRoot != null ? new Git(workingCopyRoot) : null;
    }

    public Git(File rootDir) {
        this.rootDir = rootDir;
        this.exec = new Exec(rootDir);
    }

    @Override
    public String getRevision() {
        return this.exec.cmd("git rev-parse HEAD").get(0);
    }

    @Override
    public String getRepoUrl() {
        List<String> remotes = this.exec.cmd("git ls-remote --get-url");
        for (String remote : remotes) {
            if (!remote.contains("github") && !remote.contains("bitbucket")) continue;
            return remote;
        }
        return this.exec.cmd("git config --get remote.origin.url").get(0);
    }

    @Override
    public String getBranch() {
        List<String> branches = this.exec.cmd("git branch --contains " + this.getRevision());
        for (String branch : branches) {
            if (branch.contains("* (detached from")) continue;
            return branch.substring(2);
        }
        throw new RuntimeException("Couldn't detect branch:\n" + branches);
    }

    File getRootDir() {
        return this.rootDir;
    }
}

