/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro.publisher;

import cucumber.pro.publisher.Attachment;
import cucumber.pro.publisher.GsonHelper;
import cucumber.pro.publisher.LineResult;
import cucumber.pro.publisher.Status;
import cucumber.pro.scm.Scm;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import cucumber.runtime.io.URLOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

class LineResultPublisherClient {
    private static final Map<String, String> HEADERS = new HashMap<String, String>(){
        {
            this.put("Accept", "application/json");
            this.put("Content-Type", "application/json");
            this.put("Authorization", "token " + new Env("cucumber-pro").get("GITHUB_TOKEN"));
        }
    };
    private static AtomicBoolean ERROR_PRINTED = new AtomicBoolean();
    private final URL baseUrl;
    private final File resultBackupDir;
    private final String run;
    final URL resultsUrl;
    final Scm scm;
    private long backupCounter = System.currentTimeMillis();

    public LineResultPublisherClient(URL baseUrl, String run, File resultBackupDir, Scm scm) {
        this.baseUrl = baseUrl;
        this.scm = scm;
        this.run = run;
        this.resultsUrl = this.getResultsUrl();
        this.resultBackupDir = resultBackupDir;
        if (!resultBackupDir.exists()) {
            this.resultBackupDir.mkdirs();
        }
    }

    private URL getResultsUrl() {
        try {
            return new URL(this.baseUrl, "api/" + this.scm.getName() + "/" + this.scm.getHeadRevision() + "/results");
        }
        catch (MalformedURLException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    String relativePathFromProjectRoot(String pathOrFragment) {
        File file = new File(pathOrFragment);
        if (file.isFile() && file.isAbsolute() && file.getAbsolutePath().startsWith(this.scm.getRootDirectory().getAbsolutePath())) {
            String relativePathFromRoot = file.getAbsolutePath().substring(this.scm.getRootDirectory().getAbsolutePath().length() + 1);
            return this.scm.relativePathFromRoot(relativePathFromRoot);
        }
        return this.scm.relativePathFromRoot(pathOrFragment);
    }

    public void publishLineResult(String pathOrFragment, Integer line, Status status, List<Attachment> attachments) {
        LineResult lineResult = new LineResult(this.run, this.relativePathFromProjectRoot(pathOrFragment), line, status, attachments);
        this.publishLineResult(lineResult);
    }

    public void publishLineResult(LineResult lineResult) {
        block5: {
            String json = GsonHelper.GSON.toJson((Object)lineResult);
            try {
                this.writeResult(json, (OutputStream)new URLOutputStream(this.resultsUrl, "POST", HEADERS, 201));
                if (lineResult.getSource() != null) {
                    lineResult.getSource().delete();
                }
            }
            catch (IOException publicationFailed) {
                this.printErrorOnce(publicationFailed);
                if (lineResult.getSource() != null) break block5;
                try {
                    File file = new File(this.resultBackupDir, String.valueOf(this.backupCounter++) + ".json");
                    System.err.format("Storing result in %s\n", file.getPath());
                    this.writeResult(json, (OutputStream)new URLOutputStream(file.toURI().toURL()));
                }
                catch (IOException fileStorageFailed) {
                    throw new CucumberException("FATAL: Failed to publish and then failed to store result locally.", (Throwable)fileStorageFailed);
                }
            }
        }
    }

    private void printErrorOnce(IOException publicationFailed) {
        if (!ERROR_PRINTED.get()) {
            publicationFailed.printStackTrace();
            ERROR_PRINTED.set(true);
        }
    }

    private void writeResult(String json, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, Charset.forName("utf-8"));
        writer.write(json);
        writer.flush();
        writer.close();
    }
}

