/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro;

import cucumber.pro.publisher.Attachment;
import cucumber.pro.publisher.LineResultPublisher;
import cucumber.pro.publisher.Status;
import cucumber.pro.scm.GitScm;
import cucumber.runtime.CucumberException;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class CucumberFormatter
implements Formatter,
Reporter {
    private static final File PWD = new File(System.getProperty("user.dir"));
    private static final Charset UTF_8 = Charset.forName("utf-8");
    public static final long TIMEOUT_MILLIS = 10000L;
    private final LineResultPublisher lineResultPublisher;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<Step> steps = new ArrayList<Step>();
    private BasicStatement statement;
    private String uri;

    public CucumberFormatter(URL baseUrl) throws IOException {
        this.lineResultPublisher = new LineResultPublisher(baseUrl, new GitScm(PWD));
    }

    public void before(Match match, Result result) {
    }

    public void result(Result result) {
        this.publishResult(result, (BasicStatement)this.steps.remove(0));
    }

    public void after(Match match, Result result) {
        this.publishResult(result, this.statement);
    }

    private void publishResult(Result result, BasicStatement stmt) {
        String errorMessage = result.getErrorMessage();
        if (errorMessage != null) {
            this.attachments.add(Attachment.fromException(errorMessage));
        }
        this.lineResultPublisher.publishLineResult(this.uri, stmt.getLine(), this.getStatus(result), this.attachments);
        this.attachments = new ArrayList<Attachment>();
    }

    private Status getStatus(Result result) {
        return Status.valueOf(result.getStatus());
    }

    public void match(Match match) {
    }

    public void embedding(String mimeType, byte[] bytes) {
        this.attachments.add(new Attachment(bytes, mimeType));
    }

    public void write(String text) {
        this.attachments.add(new Attachment(text.getBytes(UTF_8), "text/plain"));
    }

    public void uri(String uri) {
        this.uri = uri;
    }

    public void feature(Feature feature) {
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
        this.statement = scenario;
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
    }

    public void step(Step step) {
        this.steps.add(step);
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void done() {
        try {
            this.lineResultPublisher.finish(10000L);
        }
        catch (InterruptedException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    public void close() {
    }
}

