package cucumber.pro.publisher;

import cucumber.runtime.CucumberException;

import java.io.File;
import java.util.List;

class LineResult {
    @SuppressWarnings("FieldCanBeLocal")
    private final String run;
    @SuppressWarnings("FieldCanBeLocal")
    private final String path;
    @SuppressWarnings("FieldCanBeLocal")
    private final int line;
    @SuppressWarnings("FieldCanBeLocal")
    private final Status status;
    @SuppressWarnings("FieldCanBeLocal")
    private final List<Attachment> attachments;

    /**
     * This field is only set if this instance was read from file because of a previous
     * failure to publish. It allows us to delete the file when the result is successfully sent.
     */
    private transient File source;

    public LineResult(String run, String path, int line, Status status, List<Attachment> attachments) throws CucumberException {
        this.path = path;
        this.line = line;
        this.status = status;
        this.run = run;
        this.attachments = attachments;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public File getSource() {
        return source;
    }
}
