package cucumber.pro.publisher;

import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.deps.com.google.gson.JsonDeserializationContext;
import gherkin.deps.com.google.gson.JsonDeserializer;
import gherkin.deps.com.google.gson.JsonElement;
import gherkin.deps.com.google.gson.JsonParseException;
import gherkin.deps.com.google.gson.JsonPrimitive;
import gherkin.deps.com.google.gson.JsonSerializationContext;
import gherkin.deps.com.google.gson.JsonSerializer;
import gherkin.deps.net.iharder.Base64;

import java.io.IOException;
import java.lang.reflect.Type;

class GsonHelper {
    // GSON is thread-safe, so a shared instance is OK
    public static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, new ByteArrayToBase64TypeAdapter()).create();

    private static class ByteArrayToBase64TypeAdapter implements JsonSerializer<byte[]>, JsonDeserializer<byte[]> {
        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return Base64.decode(json.getAsString());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.encodeBytes(src));
        }
    }

}
