/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro.publisher;

import cucumber.pro.publisher.GsonHelper;
import cucumber.pro.publisher.LineResult;
import cucumber.runtime.CucumberException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

class StoredLineResults {
    private final File resultBackupDir;

    public StoredLineResults(File resultBackupDir) {
        this.resultBackupDir = resultBackupDir;
    }

    public List<LineResult> readStoredResults() {
        File[] resultFiles = this.resultBackupDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".json");
            }
        });
        if (resultFiles == null) {
            resultFiles = new File[]{};
        }
        ArrayList<LineResult> results = new ArrayList<LineResult>(resultFiles.length);
        for (File resultFile : resultFiles) {
            try {
                LineResult lineResult = (LineResult)GsonHelper.GSON.fromJson((Reader)new FileReader(resultFile), LineResult.class);
                lineResult.setSource(resultFile);
                results.add(lineResult);
            }
            catch (FileNotFoundException e) {
                throw new CucumberException((Throwable)e);
            }
            catch (Exception e) {
                System.err.println("Failed to parse JSON in " + resultFile);
                throw new CucumberException((Throwable)e);
            }
        }
        return results;
    }
}

