/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro.publisher;

import cucumber.pro.publisher.Attachment;
import cucumber.pro.publisher.LineResult;
import cucumber.pro.publisher.LineResultPublisherClient;
import cucumber.pro.publisher.Status;
import cucumber.pro.publisher.StoredLineResults;
import cucumber.pro.scm.Scm;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class LineResultPublisher {
    private final ExecutorService executorService = Executors.newFixedThreadPool(5);
    private final URL baseUrl;
    private final Scm scm;
    private final File lineResultsBackupDir;
    private final String run = UUID.randomUUID().toString();

    public LineResultPublisher(URL baseUrl, Scm scm) {
        this.baseUrl = baseUrl;
        this.scm = scm;
        String results = ".cucumber-pro/results";
        this.lineResultsBackupDir = new File(scm.getRootDirectory(), results);
        scm.ignore(results);
        this.publishStoredLineResults();
    }

    public void publishLineResult(final String pathOrFragment, final Integer line, final Status status, final List<Attachment> attachments) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                LineResultPublisherClient lineResultPublisherClient = new LineResultPublisherClient(LineResultPublisher.this.baseUrl, LineResultPublisher.this.run, LineResultPublisher.this.lineResultsBackupDir, LineResultPublisher.this.scm.copy());
                lineResultPublisherClient.publishLineResult(pathOrFragment, line, status, attachments);
            }
        });
    }

    private void publishStoredLineResults() {
        StoredLineResults storedLineResults = new StoredLineResults(this.lineResultsBackupDir);
        for (LineResult lineResult : storedLineResults.readStoredResults()) {
            this.publishLineResultAsync(lineResult);
        }
    }

    private void publishLineResultAsync(final LineResult lineResult) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                LineResultPublisherClient lineResultPublisherClient = new LineResultPublisherClient(LineResultPublisher.this.baseUrl, LineResultPublisher.this.run, LineResultPublisher.this.lineResultsBackupDir, LineResultPublisher.this.scm.copy());
                lineResultPublisherClient.publishLineResult(lineResult);
            }
        });
    }

    public void finish(long timeoutMillis) throws InterruptedException {
        this.executorService.shutdown();
        this.executorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
    }
}

