package cucumber.pro.publisher;

import java.nio.charset.Charset;

public class Attachment {
    private static final Charset UTF_8 = Charset.forName("utf-8");
    private static final String EXCEPTION_MIME_TYPE = "text/vnd.cucumberpro.stacktrace.jvm+plain";

    public final byte[] data;
    public final String mime_type;

    public Attachment(byte[] data, String mimeType) {
        this.data = data;
        this.mime_type = mimeType;
    }

    public static Attachment fromException(String errorMessage) {
        return new Attachment(errorMessage.getBytes(UTF_8), EXCEPTION_MIME_TYPE);
    }
}
