package cucumber.pro;

import cucumber.pro.publisher.Attachment;
import cucumber.pro.publisher.LineResultPublisher;
import cucumber.pro.publisher.Status;
import cucumber.pro.scm.GitScm;
import cucumber.runtime.CucumberException;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class CucumberFormatter implements Formatter, Reporter {
    private static final File PWD = new File(System.getProperty("user.dir"));
    private static final Charset UTF_8 = Charset.forName("utf-8");
    public static final long TIMEOUT_MILLIS = 10000L;
    private final LineResultPublisher lineResultPublisher;

    // These should be cleared out
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<Step> steps = new ArrayList<Step>();
    private BasicStatement statement;
    private String uri;

    public CucumberFormatter(URL baseUrl) throws IOException {
        lineResultPublisher = new LineResultPublisher(baseUrl, new GitScm(PWD));
    }

    // Reporter API

    @Override
    public void before(Match match, Result result) {
        // Need to move format() up in CucumberScenario so statement isn't null.
//        lineResultPublisher.publishLineResult(uri, statement.getLine(), result.getStatus(), attachments);
    }

    @Override
    public void result(final Result result) {
        publishResult(result, steps.remove(0));
    }

    @Override
    public void after(Match match, Result result) {
        publishResult(result, statement);
    }

    private void publishResult(Result result, BasicStatement stmt) {
        String errorMessage = result.getErrorMessage();
        if (errorMessage != null) {
            attachments.add(Attachment.fromException(errorMessage));
        }
        lineResultPublisher.publishLineResult(uri, stmt.getLine(), getStatus(result), attachments);
        attachments = new ArrayList<Attachment>();
    }

    private Status getStatus(Result result) {
        return Status.valueOf(result.getStatus());
    }

    @Override
    public void match(Match match) {
    }

    @Override
    public void embedding(String mimeType, byte[] bytes) {
        attachments.add(new Attachment(bytes, mimeType));
    }

    @Override
    public void write(String text) {
        attachments.add(new Attachment(text.getBytes(UTF_8), "text/plain"));
    }

    // Formatter

    @Override
    public void uri(String uri) {
        this.uri = uri;
    }

    @Override
    public void feature(Feature feature) {
    }

    @Override
    public void background(Background background) {
    }

    @Override
    public void scenario(Scenario scenario) {
        this.statement = scenario;
    }

    @Override
    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    @Override
    public void examples(Examples examples) {
    }

    @Override
    public void step(Step step) {
        steps.add(step);
    }

    @Override
    public void eof() {
    }

    @Override
    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    @Override
    public void done() {
        try {
            lineResultPublisher.finish(TIMEOUT_MILLIS);
        } catch (InterruptedException e) {
            throw new CucumberException(e);
        }
    }

    @Override
    public void close() {
    }
}
