/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro.results;

import cucumber.pro.Global;
import cucumber.pro.results.Debug;
import cucumber.pro.results.Header;
import cucumber.pro.results.JsonDecoder;
import cucumber.pro.results.JsonEncoder;
import cucumber.pro.results.MetadataApi;
import cucumber.pro.results.Response;
import cucumber.pro.results.Status;
import cucumber.pro.results.metadata.Metadata;
import cucumber.pro.results.metadata.StackTrace;
import cucumber.pro.results.metadata.TestCaseResult;
import cucumber.pro.results.metadata.TestStepResult;
import cucumber.runtime.CucumberException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.core.HandshakeException;

@ClientEndpoint(encoders={JsonEncoder.class}, decoders={JsonDecoder.class})
public class WebSocketMetadataClient
implements MetadataApi {
    private static final long CONNECTION_TIMEOUT_MILLIS = Long.parseLong(Global.ENV.get("CUCUMBER_PRO_CONNECTION_TIMEOUT_MILLIS", "10000"));
    private final Future<Session> sessionFuture;
    private final URI uri;
    private final Lock lock = new ReentrantLock();
    private final Condition noPendingMessages = this.lock.newCondition();
    private int pendingMessageCount = 0;
    private Throwable protocolError;

    public WebSocketMetadataClient(URI uri) throws URISyntaxException, IOException, DeploymentException {
        this.uri = uri;
        Debug.debug("Resolving hostname %s", uri.getHost());
        String hostAddress = InetAddress.getByName(uri.getHost()).getHostAddress();
        Debug.debug("Resolved to %s", hostAddress);
        ClientManager client = ClientManager.createClient();
        this.sessionFuture = client.asyncConnectToServer((Object)this, uri);
    }

    @Override
    public void sendHeader(String repoUrl, String rev, String branch, String buildId) {
        this.sendObject(new Header(repoUrl, rev, branch, buildId));
    }

    @Override
    public void sendTestStepResult(String path, int location, Status status) {
        this.sendObject(new TestStepResult(path, location, status));
    }

    @Override
    public void sendTestCaseResult(String path, int location, Status status) {
        this.sendObject(new TestCaseResult(path, location, status));
    }

    @Override
    public void sendStackTrace(String path, int location, String stackTrace) {
        this.sendObject(new StackTrace(path, location, stackTrace));
    }

    @Override
    public void sendMetadata(String path, int location, String mimeType) {
        this.sendObject(new Metadata(path, location, mimeType));
    }

    @Override
    public void sendBinary(byte[] attachment) {
        this.getEndpoint().sendBinary(ByteBuffer.wrap(attachment));
        this.incPendingMessages();
    }

    private void sendObject(Object data) {
        this.getEndpoint().sendObject(data);
        this.incPendingMessages();
    }

    private void incPendingMessages() {
        try {
            this.lock.lock();
            ++this.pendingMessageCount;
        }
        finally {
            this.lock.unlock();
        }
    }

    @OnMessage
    public void onMessage(Response response) {
        CucumberException exception = response.getException();
        if (exception != null) {
            this.setError((Throwable)exception);
        } else {
            try {
                this.lock.lock();
                --this.pendingMessageCount;
                if (this.pendingMessageCount == 0) {
                    this.noPendingMessages.signal();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void waitForReplies(int timeoutMillis) throws InterruptedException {
        try {
            this.lock.lock();
            Debug.debug("Waiting for in-flight acks: %s", this.pendingMessageCount);
            this.noPendingMessages.await(timeoutMillis, TimeUnit.MILLISECONDS);
            if (this.pendingMessageCount > 0) {
                throw new CucumberException("Timed out waiting for replies from Cucumber Pro. Pending messages: " + this.pendingMessageCount);
            }
            if (this.protocolError != null) {
                throw new CucumberException(this.protocolError);
            }
            Debug.debug("All acks received", new Object[0]);
        }
        finally {
            this.lock.unlock();
        }
    }

    private RemoteEndpoint.Async getEndpoint() {
        try {
            Session session = this.sessionFuture.get(CONNECTION_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            if (session == null) {
                throw new CucumberException("Couldn't connect to " + this.uri);
            }
            return session.getAsyncRemote();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DeploymentException) {
                DeploymentException de = (DeploymentException)e.getCause();
                if (de.getCause() instanceof HandshakeException) {
                    HandshakeException he = (HandshakeException)de.getCause();
                    switch (he.getHttpStatusCode()) {
                        case 401: {
                            throw new CucumberException("Couldn't authenticate user: " + this.uri.getQuery());
                        }
                        case 403: {
                            throw new CucumberException("Access denied: " + this.uri.getQuery());
                        }
                    }
                    throw he;
                }
                throw new CucumberException((Throwable)e);
            }
            throw new CucumberException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new CucumberException("Timed out connecting to " + this.uri, (Throwable)e);
        }
        catch (Exception e) {
            throw new CucumberException((Throwable)e);
        }
    }

    @OnError
    public void onError(Throwable t) {
        this.setError(t);
    }

    private void setError(Throwable t) {
        if (this.protocolError == null) {
            try {
                this.lock.lock();
                this.protocolError = t;
                this.pendingMessageCount = 0;
                this.noPendingMessages.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @OnClose
    public void onClose(CloseReason reason) {
        if (reason.getCloseCode().getCode() == 1002) {
            this.setError((Throwable)new CucumberException("Protocol error"));
        }
        this.sessionFuture.cancel(true);
    }
}

