package cucumber.pro.scm;

import java.io.File;

import static cucumber.pro.Global.ENV;

public class WorkingCopyDetector {
    private static final File PWD = new File(System.getProperty("user.dir"));

    public static WorkingCopy detect() {
        WorkingCopy result = GitWorkingCopy.detect(PWD);
        if (result == null) {
            result = SvnWorkingCopy.detect(PWD);
        }
        if (result == null) {
            String repoUrl = getEnv("CUCUMBER_PRO_REPO_URL");
            String branch = getEnv("CUCUMBER_PRO_BRANCH");
            String rev = getEnv("CUCUMBER_PRO_REV");
            return new CustomWorkingCopy(repoUrl, branch, rev);
        }
        return result;
    }

    private static String getEnv(String key) {
        String value = ENV.get(key);
        if (value == null) {
            String message = "No git or subversion working copy detected. You must define the " + key + " environment variable.";
            throw new RuntimeException(message);
        }
        return value;
    }
}
