/*
 * Decompiled with CFR 0.152.
 */
package cucumber.pro;

import cucumber.pro.results.BuildIdGenerator;
import cucumber.pro.results.MetadataApi;
import cucumber.pro.results.NullMetadataClient;
import cucumber.pro.results.Status;
import cucumber.pro.results.WebSocketMetadataClient;
import cucumber.pro.scm.WorkingCopy;
import cucumber.pro.scm.WorkingCopyDetector;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.websocket.DeploymentException;

public class CucumberProFormatter
implements Formatter,
Reporter {
    private static final int REPLY_TIMEOUT_MILLIS = 5000;
    private static final List<String> BUILD_NUMBER_ENV_VARS = Arrays.asList("BUILD_NUMBER", "CIRCLE_BUILD_NUM", "TRAVIS_JOB_NUMBER", "bamboo.buildNumber", "CI_BUILD_NUMBER");
    private static Env ENV = new Env("cucumber");
    private final MetadataApi metadataApi;
    private final WorkingCopy workingCopy;
    private final BuildIdGenerator buildIdGenerator;
    private List<Step> steps = new ArrayList<Step>();
    private BasicStatement statement;
    private String uri;
    private boolean headerSent;
    private List<Status> statuses = new ArrayList<Status>();
    private int currentLine;

    private static URI resultsUri() throws URISyntaxException {
        return new URI(ENV.get("CUCUMBER_PRO_RESULTS_URL", "wss://results.cucumber.pro/ws"));
    }

    private static String getToken() {
        return ENV.get("CUCUMBER_PRO_TOKEN");
    }

    private static boolean shouldPublish() {
        return CucumberProFormatter.getToken() != null && CucumberProFormatter.isContinuousIntegration();
    }

    private static boolean isContinuousIntegration() {
        return CucumberProFormatter.getBuildNumberFromEnvironment() != null || ENV.get("CI") != null;
    }

    private static MetadataApi createMetadataApi() throws URISyntaxException, IOException, DeploymentException {
        if (CucumberProFormatter.shouldPublish()) {
            return new WebSocketMetadataClient(new URI(CucumberProFormatter.resultsUri().toString() + "?token=" + CucumberProFormatter.getToken()));
        }
        return new NullMetadataClient();
    }

    public CucumberProFormatter() throws Exception {
        this(CucumberProFormatter.createMetadataApi(), WorkingCopyDetector.detect(), BuildIdGenerator.DEFAULT);
    }

    CucumberProFormatter(MetadataApi metadataApi, WorkingCopy workingCopy, BuildIdGenerator buildIdGenerator) {
        this.metadataApi = metadataApi;
        this.workingCopy = workingCopy;
        this.buildIdGenerator = buildIdGenerator;
        if (CucumberProFormatter.shouldPublish() && !"NO".equalsIgnoreCase(ENV.get("CHECK_CLEAN"))) {
            workingCopy.checkClean();
        }
    }

    public void before(Match match, Result result) {
    }

    public void result(Result result) {
        this.publishResult(result, (BasicStatement)this.steps.remove(0));
    }

    public void after(Match match, Result result) {
        this.publishResult(result, this.statement);
    }

    private void publishResult(Result result, BasicStatement stmt) {
        Status status = this.getStatus(result);
        this.statuses.add(status);
        this.metadataApi.sendTestStepResult(this.uri, stmt.getLine() + 1, status);
        String errorMessage = result.getErrorMessage();
        if (errorMessage != null) {
            this.metadataApi.sendStackTrace(this.uri, stmt.getLine() + 1, errorMessage);
        }
    }

    public void match(Match match) {
    }

    public void embedding(String mimeType, byte[] bytes) {
        this.metadataApi.sendMetadata(this.uri, this.currentLine + 1, mimeType);
        this.metadataApi.sendBinary(bytes);
    }

    public void write(String text) {
    }

    public void uri(String uri) {
        this.uri = uri;
    }

    public void feature(Feature feature) {
        if (!this.headerSent) {
            String buildNumber = CucumberProFormatter.getBuildNumberFromEnvironment();
            if (buildNumber == null) {
                buildNumber = this.buildIdGenerator.buildId();
            }
            this.metadataApi.sendHeader(this.workingCopy.getRepoUrl(), this.workingCopy.getRev(), this.workingCopy.getBranch(), buildNumber);
            this.headerSent = true;
        }
    }

    private static String getBuildNumberFromEnvironment() {
        for (String var : BUILD_NUMBER_ENV_VARS) {
            String buildId = ENV.get(var);
            if (buildId == null) continue;
            return buildId;
        }
        return null;
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
        this.statement = scenario;
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.statuses.clear();
    }

    public void step(Step step) {
        this.currentLine = step.getLine();
        this.steps.add(step);
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        this.metadataApi.sendTestCaseResult(this.uri, scenario.getLine() + 1, this.getStatus());
    }

    private Status getStatus() {
        int pos = 0;
        for (Status status : this.statuses) {
            int p = Arrays.binarySearch((Object[])Status.values(), (Object)status);
            pos = Math.max(pos, p);
        }
        return Status.values()[pos];
    }

    private Status getStatus(Result result) {
        return Status.valueOf(result.getStatus());
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void done() {
        try {
            this.metadataApi.waitForReplies(5000);
        }
        catch (InterruptedException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    public void close() {
    }
}

