/*
 * Decompiled with CFR 0.152.
 */
package cucumber.junit;

import cucumber.junit.DescriptionFactory;
import cucumber.junit.JUnitReporter;
import cucumber.runtime.Runtime;
import cucumber.runtime.model.CucumberScenario;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Step;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

class ExecutionUnitRunner
extends ParentRunner<Step> {
    private final Runtime runtime;
    private final CucumberScenario cucumberScenario;
    private final JUnitReporter jUnitReporter;
    private Description description;
    private final Map<Step, Description> stepDescriptions = new HashMap<Step, Description>();

    public ExecutionUnitRunner(Runtime runtime, CucumberScenario cucumberScenario, JUnitReporter jUnitReporter) throws InitializationError {
        super(ExecutionUnitRunner.class);
        this.runtime = runtime;
        this.cucumberScenario = cucumberScenario;
        this.jUnitReporter = jUnitReporter;
    }

    protected List<Step> getChildren() {
        return this.cucumberScenario.getSteps();
    }

    public String getName() {
        return this.cucumberScenario.getVisualName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = DescriptionFactory.createDescription(this.getName(), this.cucumberScenario);
            if (this.cucumberScenario.getCucumberBackground() != null) {
                for (Step backgroundStep : this.cucumberScenario.getCucumberBackground().getSteps()) {
                    this.description.addChild(this.describeChild(backgroundStep));
                }
            }
            for (Step step : this.getChildren()) {
                this.description.addChild(this.describeChild(step));
            }
        }
        return this.description;
    }

    protected Description describeChild(Step step) {
        Description description = this.stepDescriptions.get(step);
        if (description == null) {
            description = DescriptionFactory.createDescription(step.getKeyword() + step.getName(), step);
            this.stepDescriptions.put(step, description);
        }
        return description;
    }

    public void run(RunNotifier notifier) {
        this.jUnitReporter.startExecutionUnit(this, notifier);
        this.cucumberScenario.run((Formatter)this.jUnitReporter, (Reporter)this.jUnitReporter, this.runtime);
        this.jUnitReporter.finishExecutionUnit();
    }

    protected void runChild(Step step, RunNotifier notifier) {
        throw new UnsupportedOperationException();
    }
}

