/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.ObjectFactory;
import cucumber.runtime.CucumberException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

class DefaultJavaObjectFactory
implements ObjectFactory {
    private final Map<Class<?>, Object> instances = new HashMap();

    DefaultJavaObjectFactory() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.instances.clear();
    }

    @Override
    public void addClass(Class<?> clazz) {
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        T instance = type.cast(this.instances.get(type));
        if (instance == null) {
            instance = this.cacheNewInstance(type);
        }
        return instance;
    }

    private <T> T cacheNewInstance(Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            T instance = constructor.newInstance(new Object[0]);
            this.instances.put(type, instance);
            return instance;
        }
        catch (NoSuchMethodException e) {
            throw new CucumberException(String.format("%s doesn't have an empty constructor. If you need DI, put cucumber-picocontainer on the classpath", type), (Throwable)e);
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Failed to instantiate %s", type), (Throwable)e);
        }
    }
}

