/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.annotation.After;
import cucumber.annotation.Before;
import cucumber.annotation.Order;
import cucumber.fallback.runtime.java.DefaultJavaObjectFactory;
import cucumber.io.ClasspathResourceLoader;
import cucumber.io.ResourceLoader;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.Utils;
import cucumber.runtime.java.ClasspathMethodScanner;
import cucumber.runtime.java.JavaHookDefinition;
import cucumber.runtime.java.JavaSnippet;
import cucumber.runtime.java.JavaStepDefinition;
import cucumber.runtime.java.ObjectFactory;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;

public class JavaBackend
implements Backend {
    private final SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new JavaSnippet());
    private final ObjectFactory objectFactory;
    private final ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader(Thread.currentThread().getContextClassLoader());
    private final ClasspathMethodScanner classpathMethodScanner = new ClasspathMethodScanner(this.classpathResourceLoader);
    private Glue glue;

    public JavaBackend(ResourceLoader ignored) {
        this.objectFactory = this.loadObjectFactory();
    }

    public JavaBackend(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    private ObjectFactory loadObjectFactory() {
        ObjectFactory objectFactory;
        try {
            objectFactory = (ObjectFactory)this.classpathResourceLoader.instantiateExactlyOneSubclass(ObjectFactory.class, "cucumber.runtime", new Class[0], new Object[0]);
        }
        catch (CucumberException ce) {
            objectFactory = new DefaultJavaObjectFactory();
        }
        return objectFactory;
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        this.classpathMethodScanner.scan(this, gluePaths);
    }

    public void loadGlue(Glue glue, Method method, Class<?> glueCodeClass) {
        this.glue = glue;
        this.classpathMethodScanner.scan(this, method, glueCodeClass);
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
        this.objectFactory.start();
    }

    public void disposeWorld() {
        this.objectFactory.stop();
    }

    public String getSnippet(Step step) {
        return this.snippetGenerator.getSnippet(step);
    }

    void addStepDefinition(Annotation annotation, Method method) {
        try {
            this.objectFactory.addClass(method.getDeclaringClass());
            this.glue.addStepDefinition((StepDefinition)new JavaStepDefinition(method, this.pattern(annotation), this.timeout(annotation), this.objectFactory));
        }
        catch (DuplicateStepDefinitionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CucumberException(e);
        }
    }

    private Pattern pattern(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("value", new Class[0]);
        String regexpString = (String)Utils.invoke((Object)annotation, (Method)regexpMethod, (int)0, (Object[])new Object[0]);
        return Pattern.compile(regexpString);
    }

    private int timeout(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("timeout", new Class[0]);
        return (Integer)Utils.invoke((Object)annotation, (Method)regexpMethod, (int)0, (Object[])new Object[0]);
    }

    void addHook(Annotation annotation, Method method) {
        int hookOrder;
        this.objectFactory.addClass(method.getDeclaringClass());
        Order order = method.getAnnotation(Order.class);
        int n = hookOrder = order == null ? Integer.MAX_VALUE : order.value();
        if (annotation.annotationType().equals(Before.class)) {
            String[] tagExpressions = ((Before)annotation).value();
            int timeout = ((Before)annotation).timeout();
            this.glue.addBeforeHook((HookDefinition)new JavaHookDefinition(method, tagExpressions, hookOrder, timeout, this.objectFactory));
        } else {
            String[] tagExpressions = ((After)annotation).value();
            int timeout = ((After)annotation).timeout();
            this.glue.addAfterHook((HookDefinition)new JavaHookDefinition(method, tagExpressions, hookOrder, timeout, this.objectFactory));
        }
    }
}

