/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.Utils;
import gherkin.util.FixJava;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class URLOutputStream
extends OutputStream {
    private OutputStream out;
    private HttpURLConnection urlConnection;

    public URLOutputStream(URL url) throws IOException {
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            Utils.ensureParentDirExists(file);
            this.out = new FileOutputStream(file);
        } else if (url.getProtocol().startsWith("http")) {
            this.urlConnection = (HttpURLConnection)url.openConnection();
            this.urlConnection.setRequestMethod("PUT");
            this.urlConnection.setDoOutput(true);
            this.out = this.urlConnection.getOutputStream();
        } else {
            throw new IllegalArgumentException("URL Scheme must be one of file,http,https. " + url.toExternalForm());
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        int responseCode;
        if (this.urlConnection != null && (responseCode = this.urlConnection.getResponseCode()) >= 400) {
            try {
                this.urlConnection.getInputStream().close();
            }
            catch (IOException e) {
                InputStream errorStream = this.urlConnection.getErrorStream();
                if (errorStream != null) {
                    String body = FixJava.readReader(new InputStreamReader(errorStream, "UTF-8"));
                    throw new IOException(body, e);
                }
                throw e;
            }
        }
        this.out.close();
    }
}

