/*
 * Decompiled with CFR 0.152.
 */
package cucumber.table;

import cucumber.runtime.CucumberException;
import cucumber.runtime.xstream.XStream;
import cucumber.runtime.xstream.converters.Converter;
import cucumber.runtime.xstream.converters.SingleValueConverter;
import cucumber.runtime.xstream.converters.reflection.AbstractReflectionConverter;
import cucumber.runtime.xstream.io.AbstractReader;
import cucumber.table.CamelCaseStringConverter;
import cucumber.table.DataTable;
import cucumber.table.xstream.DataTableWriter;
import cucumber.table.xstream.ListOfListOfSingleValueReader;
import cucumber.table.xstream.ListOfListOfSingleValueWriter;
import cucumber.table.xstream.ListOfMapReader;
import cucumber.table.xstream.ListOfObjectReader;
import cucumber.table.xstream.ListOfObjectWriter;
import gherkin.util.FixJava;
import gherkin.util.Mapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TableConverter {
    private final XStream xStream;

    public TableConverter(XStream xStream) {
        this.xStream = xStream;
    }

    public <T> List<T> toList(Type itemType, DataTable dataTable) {
        this.ensureNotNonGenericMap(itemType);
        Class listOfListType = this.listOfListType(itemType);
        AbstractReader reader = listOfListType != null ? new ListOfListOfSingleValueReader(listOfListType, dataTable.cells(0)) : (this.isMapOfStringToStringAssignable(itemType) ? new ListOfMapReader(dataTable.topCells(), dataTable.cells(1)) : new ListOfObjectReader(itemType, this.convertedAttributeNames(dataTable), dataTable.cells(1)));
        try {
            return (List)this.xStream.unmarshal(reader);
        }
        catch (AbstractReflectionConverter.UnknownFieldException e) {
            throw new CucumberException(e.getShortMessage());
        }
    }

    public DataTable toTable(List<?> objects, String ... columnNames) {
        DataTableWriter writer;
        if (this.isListOfListOfSingleValue(objects)) {
            objects = this.wrapLists(objects);
            writer = new ListOfListOfSingleValueWriter(this);
        } else {
            writer = new ListOfObjectWriter(this);
        }
        this.xStream.marshal(objects, writer);
        return writer.getDataTable();
    }

    private List<List<?>> wrapLists(List<List<?>> lists) {
        ArrayList result = new ArrayList();
        for (List<?> list : lists) {
            ArrayList resultList = new ArrayList(list);
            result.add(resultList);
        }
        return result;
    }

    private List<String> convertedAttributeNames(DataTable dataTable) {
        final CamelCaseStringConverter mapper = new CamelCaseStringConverter();
        return FixJava.map(dataTable.topCells(), (Mapper)new Mapper<String, String>(){

            public String map(String attributeName) {
                return mapper.map(attributeName);
            }
        });
    }

    private boolean isListOfListOfSingleValue(List<?> objects) {
        List firstList;
        return objects.size() > 0 && objects.get(0) instanceof List && (firstList = (List)objects.get(0)).size() > 0 && this.isSingleValue(firstList.get(0).getClass());
    }

    private void ensureNotNonGenericMap(Type type) {
        if (type instanceof Class && Map.class.isAssignableFrom((Class)type)) {
            throw new CucumberException("Tables can only be transformed to List<Map<String,String>> or List<Map<String,Object>>. You have to declare generic types.");
        }
    }

    private Class listOfListType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class && List.class.isAssignableFrom((Class)rawType)) {
                Type listType = parameterizedType.getActualTypeArguments()[0];
                if (listType instanceof Class) {
                    return (Class)listType;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private boolean isMapOfStringToStringAssignable(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class && Map.class.isAssignableFrom((Class)rawType)) {
                boolean isStringAssignableValue;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                boolean isStringKey = actualTypeArguments[0].equals(String.class);
                if (!isStringKey) {
                    throw new CucumberException("Tables can only be transformed to a List<Map<K,V>> when K is String. It was " + actualTypeArguments[0].toString() + ".");
                }
                boolean bl = isStringAssignableValue = actualTypeArguments[1] instanceof Class && ((Class)actualTypeArguments[1]).isAssignableFrom(String.class);
                if (!isStringAssignableValue) {
                    throw new CucumberException("Tables can only be transformed to a List<Map<K,V>> when V is String or Object. It was " + actualTypeArguments[1].toString() + ".");
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isSingleValue(Class<?> type) {
        Converter converter = this.xStream.getConverterLookup().lookupConverterForType(type);
        return converter instanceof SingleValueConverter;
    }
}

