/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.converters;

import cucumber.runtime.converters.BigDecimalConverter;
import cucumber.runtime.converters.BigIntegerConverter;
import cucumber.runtime.converters.ByteConverter;
import cucumber.runtime.converters.CalendarConverter;
import cucumber.runtime.converters.DateConverter;
import cucumber.runtime.converters.DoubleConverter;
import cucumber.runtime.converters.FloatConverter;
import cucumber.runtime.converters.IntegerConverter;
import cucumber.runtime.converters.LongConverter;
import cucumber.runtime.converters.SingleValueConverterWrapperExt;
import cucumber.runtime.converters.TimeConverter;
import cucumber.runtime.xstream.XStream;
import cucumber.runtime.xstream.converters.SingleValueConverter;
import cucumber.runtime.xstream.core.DefaultConverterLookup;
import gherkin.I18n;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocalizedXStreams {
    private final Map<I18n, LocalizedXStream> xStreams = new HashMap<I18n, LocalizedXStream>();
    private final ClassLoader classLoader;

    public LocalizedXStreams(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public LocalizedXStream get(I18n i18n) {
        LocalizedXStream xStream = this.xStreams.get(i18n);
        if (xStream == null) {
            xStream = this.newXStream(i18n.getLocale());
            this.xStreams.put(i18n, xStream);
        }
        return xStream;
    }

    private LocalizedXStream newXStream(Locale locale) {
        DefaultConverterLookup lookup = new DefaultConverterLookup();
        return new LocalizedXStream(this.classLoader, lookup, locale);
    }

    public static class LocalizedXStream
    extends XStream {
        private final Locale locale;
        private static List<TimeConverter> timeConverters = new ArrayList<TimeConverter>();

        public LocalizedXStream(ClassLoader classLoader, DefaultConverterLookup lookup, Locale locale) {
            super(null, null, classLoader, null, lookup, lookup);
            this.locale = locale;
            this.autodetectAnnotations(true);
            this.register(lookup, new BigDecimalConverter(locale));
            this.register(lookup, new BigIntegerConverter(locale));
            this.register(lookup, new ByteConverter(locale));
            this.register(lookup, new DateConverter(locale));
            this.register(lookup, new CalendarConverter(locale));
            this.register(lookup, new DoubleConverter(locale));
            this.register(lookup, new FloatConverter(locale));
            this.register(lookup, new IntegerConverter(locale));
            this.register(lookup, new LongConverter(locale));
        }

        private void register(DefaultConverterLookup lookup, SingleValueConverter converter) {
            lookup.registerConverter(new SingleValueConverterWrapperExt(converter), 10000);
        }

        public void setDateFormat(String dateFormat) {
            if (dateFormat != null) {
                List<Class> timeClasses = TimeConverter.getTimeClasses();
                for (Class timeClass : timeClasses) {
                    SingleValueConverterWrapperExt converterWrapper = (SingleValueConverterWrapperExt)this.getConverterLookup().lookupConverterForType(timeClass);
                    TimeConverter timeConverter = (TimeConverter)converterWrapper.getConverter();
                    timeConverter.setOnlyFormat(dateFormat, this.locale);
                    timeConverters.add(timeConverter);
                }
            }
        }

        public void unsetDateFormat() {
            for (TimeConverter timeConverter : timeConverters) {
                timeConverter.removeOnlyFormat();
            }
            timeConverters.clear();
        }
    }
}

