/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.runtime.CucumberException;
import cucumber.runtime.ParameterType;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import cucumber.runtime.converters.EnumConverter;
import cucumber.runtime.converters.LocalizedXStreams;
import cucumber.runtime.converters.TimeConverter;
import cucumber.runtime.xstream.XStream;
import cucumber.runtime.xstream.converters.ConverterLookup;
import cucumber.runtime.xstream.converters.SingleValueConverter;
import cucumber.table.DataTable;
import cucumber.table.TableConverter;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Step;
import gherkin.util.FixJava;
import gherkin.util.Mapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class StepDefinitionMatch
extends Match {
    private final StepDefinition stepDefinition;
    private final transient String uri;
    private final transient Step step;
    private final LocalizedXStreams localizedXStreams;

    public StepDefinitionMatch(List<Argument> arguments, StepDefinition stepDefinition, String uri, Step step, LocalizedXStreams localizedXStreams) {
        super(arguments, stepDefinition.getLocation(false));
        this.stepDefinition = stepDefinition;
        this.uri = uri;
        this.step = step;
        this.localizedXStreams = localizedXStreams;
    }

    public void runStep(I18n i18n) throws Throwable {
        try {
            Object[] args = this.transformedArgs(this.stepDefinition.getParameterTypes(), this.step, this.localizedXStreams.get(i18n), i18n.getLocale());
            this.stepDefinition.execute(i18n, args);
        }
        catch (CucumberException e) {
            throw e;
        }
        catch (Throwable t) {
            throw this.removeFrameworkFramesAndAppendStepLocation(t, this.getStepLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] transformedArgs(List<ParameterType> parameterTypes, Step step, LocalizedXStreams.LocalizedXStream xStream, Locale locale) {
        if (xStream == null) {
            throw new NullPointerException("xStream");
        }
        int argumentCount = this.getArguments().size();
        if (step.getDocString() != null) {
            ++argumentCount;
        }
        if (step.getRows() != null) {
            ++argumentCount;
        }
        if (parameterTypes != null) {
            if (parameterTypes.size() != argumentCount) {
                throw this.arityMismatch(parameterTypes, step);
            }
        } else {
            parameterTypes = Utils.listOf(argumentCount, new ParameterType((Type)((Object)String.class), null));
        }
        Object[] result = new Object[argumentCount];
        ConverterLookup converterLookup = xStream.getConverterLookup();
        int n = 0;
        for (Argument a : this.getArguments()) {
            SingleValueConverter converter;
            TimeConverter timeConverter = null;
            ParameterType parameterType = parameterTypes.get(n);
            if (parameterType.getDateFormat() != null) {
                timeConverter = TimeConverter.getInstance(parameterType, locale);
                timeConverter.setOnlyFormat(parameterType.getDateFormat(), locale);
                converter = timeConverter;
            } else {
                converter = parameterType.getParameterClass().isEnum() ? new EnumConverter(locale, parameterType.getParameterClass()) : (SingleValueConverter)((Object)converterLookup.lookupConverterForType(parameterType.getParameterClass()));
            }
            try {
                result[n] = converter.fromString(a.getVal());
            }
            finally {
                if (timeConverter != null) {
                    timeConverter.removeOnlyFormat();
                }
            }
            ++n;
        }
        if (step.getRows() != null) {
            ParameterType parameterType = parameterTypes.get(n);
            xStream.setDateFormat(parameterType.getDateFormat());
            try {
                result[n] = this.tableArgument(step, n, xStream, parameterType.getDateFormat());
            }
            finally {
                xStream.unsetDateFormat();
            }
        } else if (step.getDocString() != null) {
            result[n] = step.getDocString().getValue();
        }
        return result;
    }

    private CucumberException arityMismatch(List<ParameterType> parameterTypes, Step step) {
        List<Argument> arguments = this.createArgumentsForErrorMessage(step);
        return new CucumberException(String.format("Arity mismatch: Step Definition '%s' with pattern /%s/ is declared with %s parameters%s. However, the gherkin step matched %s arguments%s. \nStep: %s%s", this.stepDefinition.getLocation(true), this.stepDefinition.getPattern(), parameterTypes.size(), parameterTypes.isEmpty() ? "" : " " + parameterTypes.toString(), arguments.size(), arguments.isEmpty() ? "" : " " + arguments.toString(), step.getKeyword(), step.getName()));
    }

    private List<Argument> createArgumentsForErrorMessage(Step step) {
        ArrayList<Argument> arguments = new ArrayList<Argument>(this.getArguments());
        if (step.getDocString() != null) {
            arguments.add(new Argument(-1, "DocString:" + step.getDocString().getValue()));
        }
        if (step.getRows() != null) {
            List rows = FixJava.map((List)step.getRows(), (Mapper)new Mapper<DataTableRow, List<String>>(){

                public List<String> map(DataTableRow row) {
                    return row.getCells();
                }
            });
            arguments.add(new Argument(-1, "Table:" + rows.toString()));
        }
        return arguments;
    }

    private Object tableArgument(Step step, int argIndex, XStream xStream, String dateFormat) {
        DataTable table = new DataTable(step.getRows(), new TableConverter(xStream));
        Type listType = this.getGenericListType(argIndex);
        if (listType != null) {
            return table.asList(listType);
        }
        return table;
    }

    private Type getGenericListType(int argIndex) {
        ParameterType parameterType;
        Type[] actualTypeArguments;
        Type result = null;
        List<ParameterType> parameterTypes = this.stepDefinition.getParameterTypes();
        if (parameterTypes != null && (actualTypeArguments = (parameterType = parameterTypes.get(argIndex)).getActualTypeArguments()) != null && actualTypeArguments.length > 0) {
            result = actualTypeArguments[0];
        }
        return result;
    }

    public Throwable removeFrameworkFramesAndAppendStepLocation(Throwable error, StackTraceElement stepLocation) {
        int newStackTraceLength;
        StackTraceElement[] stackTraceElements = error.getStackTrace();
        if (stackTraceElements.length == 0 || stepLocation == null) {
            return error;
        }
        for (newStackTraceLength = 1; newStackTraceLength < stackTraceElements.length && !this.stepDefinition.isDefinedAt(stackTraceElements[newStackTraceLength - 1]); ++newStackTraceLength) {
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[newStackTraceLength + 1];
        System.arraycopy(stackTraceElements, 0, newStackTrace, 0, newStackTraceLength);
        newStackTrace[newStackTraceLength] = stepLocation;
        error.setStackTrace(newStackTrace);
        return error;
    }

    public String getPattern() {
        return this.stepDefinition.getPattern();
    }

    public StackTraceElement getStepLocation() {
        return this.step.getStackTraceElement(this.uri);
    }

    public String getStepName() {
        return this.step.getName();
    }
}

