/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.io.ClasspathResourceLoader;
import cucumber.io.ResourceLoader;
import cucumber.runtime.AmbiguousStepDefinitionsException;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.PendingException;
import cucumber.runtime.RuntimeGlue;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.ScenarioResultImpl;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.UndefinedStepException;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.converters.LocalizedXStreams;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.snippets.SummaryPrinter;
import gherkin.I18n;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Runtime
implements UnreportedStepExecutor {
    private static final Object DUMMY_ARG = new Object();
    private static final byte ERRORS = 1;
    final UndefinedStepsTracker undefinedStepsTracker = new UndefinedStepsTracker();
    private final Glue glue;
    private final RuntimeOptions runtimeOptions;
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final Collection<? extends Backend> backends;
    private final ResourceLoader resourceLoader;
    private boolean skipNextStep = false;
    private ScenarioResultImpl scenarioResult = null;
    private ClassLoader classLoader;

    public Runtime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions) {
        this(resourceLoader, classLoader, Runtime.loadBackends(resourceLoader, classLoader), runtimeOptions);
    }

    public Runtime(ResourceLoader resourceLoader, ClassLoader classLoader, Collection<? extends Backend> backends, RuntimeOptions runtimeOptions) {
        this.resourceLoader = resourceLoader;
        this.classLoader = classLoader;
        if (backends.isEmpty()) {
            throw new CucumberException("No backends were found. Please make sure you have a backend module on your CLASSPATH.");
        }
        this.backends = backends;
        this.glue = new RuntimeGlue(this.undefinedStepsTracker, new LocalizedXStreams(classLoader));
        for (Backend backend : backends) {
            backend.loadGlue(this.glue, runtimeOptions.glue);
            backend.setUnreportedStepExecutor(this);
        }
        this.runtimeOptions = runtimeOptions;
    }

    private static Collection<? extends Backend> loadBackends(ResourceLoader resourceLoader, ClassLoader classLoader) {
        return new ClasspathResourceLoader(classLoader).instantiateSubclasses(Backend.class, "cucumber.runtime", new Class[]{ResourceLoader.class}, new Object[]{resourceLoader});
    }

    public void addError(Throwable error) {
        this.errors.add(error);
    }

    public void run() {
        for (CucumberFeature cucumberFeature : this.runtimeOptions.cucumberFeatures(this.resourceLoader)) {
            this.run(cucumberFeature);
        }
        Formatter formatter = this.runtimeOptions.formatter(this.classLoader);
        formatter.done();
        this.printSummary();
        formatter.close();
    }

    private void run(CucumberFeature cucumberFeature) {
        Formatter formatter = this.runtimeOptions.formatter(this.classLoader);
        Reporter reporter = this.runtimeOptions.reporter(this.classLoader);
        cucumberFeature.run(formatter, reporter, this);
    }

    private void printSummary() {
        new SummaryPrinter(System.out).print(this);
    }

    public void buildBackendWorlds(Reporter reporter) {
        for (Backend backend : this.backends) {
            backend.buildWorld();
        }
        this.undefinedStepsTracker.reset();
        this.skipNextStep = false;
        this.scenarioResult = new ScenarioResultImpl(reporter);
    }

    public void disposeBackendWorlds() {
        for (Backend backend : this.backends) {
            backend.disposeWorld();
        }
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public byte exitStatus() {
        byte result = 0;
        if (this.hasErrors() || this.hasUndefinedOrPendingStepsAndIsStrict()) {
            result = (byte)(result | 1);
        }
        return result;
    }

    private boolean hasUndefinedOrPendingStepsAndIsStrict() {
        return this.runtimeOptions.strict && this.hasUndefinedOrPendingSteps();
    }

    private boolean hasUndefinedOrPendingSteps() {
        return this.hasUndefinedSteps() || this.hasPendingSteps();
    }

    private boolean hasUndefinedSteps() {
        return this.undefinedStepsTracker.hasUndefinedSteps();
    }

    private boolean hasPendingSteps() {
        return !this.errors.isEmpty() && !this.hasErrors();
    }

    private boolean hasErrors() {
        for (Throwable error : this.errors) {
            if (error instanceof PendingException) continue;
            return true;
        }
        return false;
    }

    public List<String> getSnippets() {
        return this.undefinedStepsTracker.getSnippets(this.backends);
    }

    public Glue getGlue() {
        return this.glue;
    }

    public void runBeforeHooks(Reporter reporter, Set<Tag> tags) {
        this.runHooks(this.glue.getBeforeHooks(), reporter, tags);
    }

    public void runAfterHooks(Reporter reporter, Set<Tag> tags) {
        this.runHooks(this.glue.getAfterHooks(), reporter, tags);
    }

    private void runHooks(List<HookDefinition> hooks, Reporter reporter, Set<Tag> tags) {
        for (HookDefinition hook : hooks) {
            this.runHookIfTagsMatch(hook, reporter, tags);
        }
    }

    private void runHookIfTagsMatch(HookDefinition hook, Reporter reporter, Set<Tag> tags) {
        if (hook.matches(tags)) {
            long start = System.nanoTime();
            try {
                hook.execute(this.scenarioResult);
            }
            catch (Throwable t) {
                this.skipNextStep = true;
                long duration = System.nanoTime() - start;
                Result result = new Result("failed", Long.valueOf(duration), t, DUMMY_ARG);
                this.scenarioResult.add(result);
                reporter.result(result);
            }
        }
    }

    @Override
    public void runUnreportedStep(String uri, I18n i18n, String stepKeyword, String stepName, int line, List<DataTableRow> dataTableRows, DocString docString) throws Throwable {
        Step step = new Step(Collections.emptyList(), stepKeyword, stepName, line, dataTableRows, docString);
        StepDefinitionMatch match = this.glue.stepDefinitionMatch(uri, step, i18n);
        if (match == null) {
            UndefinedStepException error = new UndefinedStepException(step);
            StackTraceElement[] originalTrace = error.getStackTrace();
            StackTraceElement[] newTrace = new StackTraceElement[originalTrace.length + 1];
            newTrace[0] = new StackTraceElement("\u273d", "StepDefinition", uri, line);
            System.arraycopy(originalTrace, 0, newTrace, 1, originalTrace.length);
            error.setStackTrace(newTrace);
            throw error;
        }
        match.runStep(i18n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStep(String uri, Step step, Reporter reporter, I18n i18n) {
        StepDefinitionMatch match;
        try {
            match = this.glue.stepDefinitionMatch(uri, step, i18n);
        }
        catch (AmbiguousStepDefinitionsException e) {
            reporter.match((Match)e.getMatches().get(0));
            reporter.result(new Result("failed", Long.valueOf(0L), (Throwable)e, DUMMY_ARG));
            this.addError(e);
            this.skipNextStep = true;
            return;
        }
        if (match == null) {
            reporter.match(Match.UNDEFINED);
            reporter.result(Result.UNDEFINED);
            this.skipNextStep = true;
            return;
        }
        reporter.match((Match)match);
        if (this.runtimeOptions.dryRun) {
            this.skipNextStep = true;
        }
        if (this.skipNextStep) {
            this.scenarioResult.add(Result.SKIPPED);
            reporter.result(Result.SKIPPED);
        } else {
            String status = "passed";
            Throwable error = null;
            long start = System.nanoTime();
            try {
                match.runStep(i18n);
            }
            catch (Throwable t) {
                error = t;
                status = t instanceof PendingException ? "pending" : "failed";
                this.addError(t);
                this.skipNextStep = true;
            }
            finally {
                long duration = System.nanoTime() - start;
                Result result = new Result(status, Long.valueOf(duration), error, DUMMY_ARG);
                this.scenarioResult.add(result);
                reporter.result(result);
            }
        }
    }

    public void writeStepdefsJson() throws IOException {
        this.glue.writeStepdefsJson(this.runtimeOptions.featurePaths, this.runtimeOptions.dotCucumber);
    }
}

