/*
 * Decompiled with CFR 0.152.
 */
package cucumber.io;

import cucumber.io.ClasspathIterable;
import cucumber.io.FileResource;
import cucumber.io.FlatteningIterator;
import cucumber.io.Resource;
import cucumber.runtime.Utils;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Iterator;

public class FileResourceIterator
implements Iterator<Resource> {
    private final FlatteningIterator flatteningIterator;

    public FileResourceIterator(File root, File file, final String suffix) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || ClasspathIterable.hasSuffix(suffix, file.getPath());
            }
        };
        this.flatteningIterator = new FlatteningIterator(new FileIterator(root, file, filter));
    }

    @Override
    public boolean hasNext() {
        return this.flatteningIterator.hasNext();
    }

    @Override
    public Resource next() {
        return (Resource)this.flatteningIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class FileIterator
    implements Iterator<Object> {
        private final Iterator<File> files;
        private final FileFilter filter;
        private final File root;

        FileIterator(File root, File file, FileFilter filter) {
            this.root = root;
            this.files = file.isDirectory() ? Arrays.asList(file.listFiles(filter)).iterator() : (file.isFile() ? Arrays.asList(file).iterator() : Utils.emptyIterator());
            this.filter = filter;
        }

        @Override
        public Object next() {
            File next = this.files.next();
            if (next.isDirectory()) {
                return new FileIterator(this.root, next, this.filter);
            }
            return new FileResource(this.root, next);
        }

        @Override
        public boolean hasNext() {
            return this.files.hasNext();
        }

        @Override
        public void remove() {
            this.files.remove();
        }
    }
}

