/*
 * Decompiled with CFR 0.152.
 */
package cucumber.table.xstream;

import cucumber.runtime.xstream.converters.ErrorWriter;
import cucumber.runtime.xstream.io.AbstractReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ListOfMapReader
extends AbstractReader {
    private final List<String> attributeNames;
    private final Iterator<List<String>> itemIterator;
    private int depth = 0;
    private Iterator<String> attributeNameIterator;
    private String attributeName;
    private Iterator<String> attributeValueIterator;
    private String attributeValue;
    private boolean entryKey = true;

    public ListOfMapReader(List<String> attributeNames, List<List<String>> items) {
        this.attributeNames = attributeNames;
        this.itemIterator = items.iterator();
    }

    @Override
    public boolean hasMoreChildren() {
        switch (this.depth) {
            case 0: {
                return this.itemIterator.hasNext();
            }
            case 1: {
                return this.attributeNameIterator.hasNext();
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        throw new IllegalStateException("Depth is " + this.depth);
    }

    @Override
    public void moveDown() {
        ++this.depth;
        switch (this.depth) {
            case 1: {
                this.attributeNameIterator = this.attributeNames.iterator();
                this.attributeValueIterator = this.itemIterator.next().iterator();
                break;
            }
            case 2: {
                this.attributeName = this.attributeNameIterator.next();
                this.attributeValue = this.attributeValueIterator.next();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("Depth is " + this.depth);
            }
        }
    }

    @Override
    public void moveUp() {
        --this.depth;
    }

    @Override
    public String getNodeName() {
        switch (this.depth) {
            case 0: {
                return "list";
            }
            case 1: {
                return "map";
            }
            case 2: {
                return "entry";
            }
            case 3: {
                return "string";
            }
        }
        throw new IllegalStateException("Depth is " + this.depth);
    }

    @Override
    public String getValue() {
        String result = this.entryKey ? this.attributeName : this.attributeValue;
        this.entryKey = !this.entryKey;
        return result;
    }

    @Override
    public String getAttribute(String name) {
        return null;
    }

    @Override
    public String getAttribute(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAttributeCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeName(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator getAttributeNames() {
        return Collections.emptyList().iterator();
    }

    @Override
    public void appendErrors(ErrorWriter errorWriter) {
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }
}

