/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.DateFormat;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ParameterType {
    private final Type type;
    private final String dateFormat;

    public ParameterType(Type type, String dateFormat) {
        this.type = type;
        this.dateFormat = dateFormat;
    }

    public Class<?> getParameterClass() {
        if (this.type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)this.type).getRawType();
        }
        return (Class)this.type;
    }

    public Type[] getActualTypeArguments() {
        if (this.type instanceof ParameterizedType) {
            return ((ParameterizedType)this.type).getActualTypeArguments();
        }
        return null;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String toString() {
        return this.type.toString();
    }

    public static List<ParameterType> fromMethod(Method method) {
        ArrayList<ParameterType> result = new ArrayList<ParameterType>();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            String dateFormat = null;
            for (Annotation annotation : annotations[i]) {
                if (!(annotation instanceof DateFormat)) continue;
                dateFormat = ((DateFormat)annotation).value();
                break;
            }
            result.add(new ParameterType(genericParameterTypes[i], dateFormat));
        }
        return result;
    }
}

