/*
 * Decompiled with CFR 0.152.
 */
package cucumber.table;

import cucumber.runtime.converters.LocalizedXStreams;
import cucumber.table.TableConverter;
import cucumber.table.TableDiffException;
import cucumber.table.TableDiffer;
import cucumber.table.TypeReference;
import gherkin.formatter.PrettyFormatter;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Row;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DataTable {
    private final List<List<String>> raw;
    private final List<DataTableRow> gherkinRows;
    private final TableConverter tableConverter;

    public static DataTable create(List<?> raw) {
        return DataTable.create(raw, Locale.getDefault(), null, new String[0]);
    }

    public static DataTable create(List<?> raw, String dateFormat, String ... columnNames) {
        return DataTable.create(raw, Locale.getDefault(), dateFormat, columnNames);
    }

    public static DataTable create(List<?> raw, Locale locale, String ... columnNames) {
        return DataTable.create(raw, locale, null, columnNames);
    }

    private static DataTable create(List<?> raw, Locale locale, String dateFormat, String ... columnNames) {
        TableConverter tableConverter = new TableConverter(new LocalizedXStreams(Thread.currentThread().getContextClassLoader()).get(locale), dateFormat);
        return tableConverter.toTable(raw, columnNames);
    }

    public DataTable(List<DataTableRow> gherkinRows, TableConverter tableConverter) {
        this.gherkinRows = gherkinRows;
        this.tableConverter = tableConverter;
        ArrayList raw = new ArrayList();
        for (DataTableRow row : gherkinRows) {
            ArrayList list = new ArrayList();
            list.addAll(row.getCells());
            raw.add(Collections.unmodifiableList(list));
        }
        this.raw = Collections.unmodifiableList(raw);
    }

    public List<List<String>> raw() {
        return this.raw;
    }

    public <T> T convert(Type type) {
        return this.tableConverter.convert(type, this);
    }

    public List<Map<String, String>> asMaps() {
        return this.asList(new TypeReference<Map<String, String>>(){}.getType());
    }

    public <T> List<T> asList(Type type) {
        List result = this.tableConverter.toList(type, this);
        return result;
    }

    List<String> topCells() {
        return this.raw.get(0);
    }

    List<List<String>> cells(int firstRow) {
        return this.raw.subList(firstRow, this.raw.size());
    }

    public DataTable toTable(List<?> raw, String ... columnNames) {
        return this.tableConverter.toTable(raw, columnNames);
    }

    public void diff(List<?> other) throws TableDiffException {
        List<String> topCells = this.topCells();
        DataTable otherTable = this.toTable(other, topCells.toArray(new String[topCells.size()]));
        this.diff(otherTable);
    }

    void diff(DataTable other) throws TableDiffException {
        new TableDiffer(this, other).calculateDiffs();
    }

    public List<DataTableRow> getGherkinRows() {
        return Collections.unmodifiableList(this.gherkinRows);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        PrettyFormatter pf = new PrettyFormatter((Appendable)result, true, false);
        pf.table(this.getGherkinRows());
        pf.eof();
        return result.toString();
    }

    List<DiffableRow> diffableRows() {
        ArrayList<DiffableRow> result = new ArrayList<DiffableRow>();
        List<List<String>> convertedRows = this.raw();
        for (int i = 0; i < convertedRows.size(); ++i) {
            result.add(new DiffableRow((Row)this.getGherkinRows().get(i), convertedRows.get(i)));
        }
        return result;
    }

    TableConverter getTableConverter() {
        return this.tableConverter;
    }

    public List<String> flatten() {
        ArrayList<String> result = new ArrayList<String>();
        for (List<String> rows : this.raw()) {
            for (String cell : rows) {
                result.add(cell);
            }
        }
        return result;
    }

    class DiffableRow {
        public final Row row;
        public final List<String> convertedRow;

        public DiffableRow(Row row, List<String> convertedRow) {
            this.row = row;
            this.convertedRow = convertedRow;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiffableRow that = (DiffableRow)o;
            return ((Object)this.convertedRow).equals(that.convertedRow);
        }

        public int hashCode() {
            return ((Object)this.convertedRow).hashCode();
        }
    }
}

