/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream.converters.collections;

import cucumber.runtime.xstream.converters.Converter;
import cucumber.runtime.xstream.converters.MarshallingContext;
import cucumber.runtime.xstream.converters.UnmarshallingContext;
import cucumber.runtime.xstream.io.HierarchicalStreamReader;
import cucumber.runtime.xstream.io.HierarchicalStreamWriter;

public class CharArrayConverter
implements Converter {
    public boolean canConvert(Class type) {
        return type.isArray() && type.getComponentType().equals(Character.TYPE);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        char[] chars = (char[])source;
        writer.setValue(new String(chars));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return reader.getValue().toCharArray();
    }
}

