/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.DateFormat;
import cucumber.api.Transform;
import cucumber.runtime.CucumberException;
import cucumber.runtime.converters.EnumConverter;
import cucumber.runtime.converters.LocalizedXStreams;
import cucumber.runtime.xstream.annotations.XStreamConverter;
import cucumber.runtime.xstream.converters.SingleValueConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ParameterType {
    private final Type type;
    private final String dateFormat;
    private final SingleValueConverter singleValueConverter;

    public static List<ParameterType> fromMethod(Method method) {
        ArrayList<ParameterType> result = new ArrayList<ParameterType>();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            String dateFormat = null;
            SingleValueConverter singleValueConverter = null;
            for (Annotation annotation : annotations[i]) {
                if (annotation instanceof DateFormat) {
                    dateFormat = ((DateFormat)annotation).value();
                }
                if (!(annotation instanceof Transform)) continue;
                try {
                    singleValueConverter = ((Transform)annotation).value().newInstance();
                }
                catch (InstantiationException e) {
                    throw new CucumberException(e);
                }
                catch (IllegalAccessException e) {
                    throw new CucumberException(e);
                }
            }
            result.add(new ParameterType(genericParameterTypes[i], dateFormat, singleValueConverter));
        }
        return result;
    }

    public ParameterType(Type type, String dateFormat, SingleValueConverter singleValueConverter) {
        this.type = type;
        this.dateFormat = dateFormat;
        this.singleValueConverter = singleValueConverter;
    }

    public Class<?> getRawType() {
        if (this.type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)this.type).getRawType();
        }
        return (Class)this.type;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(String value, LocalizedXStreams.LocalizedXStream xStream, Locale locale) {
        try {
            SingleValueConverter converter;
            xStream.setDateFormat(this.dateFormat);
            xStream.processAnnotations(this.getRawType());
            if (this.singleValueConverter != null) {
                converter = this.singleValueConverter;
            } else if (this.getRawType().isEnum()) {
                converter = new EnumConverter(locale, this.getRawType());
            } else {
                converter = xStream.getSingleValueConverter(this.getRawType());
                if (converter == null) {
                    throw new CucumberException(String.format("Don't know how to convert \"%s\" into %s.\nTry writing your own converter:\n\n@%s(%sConverter.class)\npublic class %s {}\n", value, this.getRawType().getName(), XStreamConverter.class.getName(), this.getRawType().getSimpleName(), this.getRawType().getSimpleName()));
                }
            }
            Object object = converter.fromString(value);
            return object;
        }
        finally {
            xStream.unsetDateFormat();
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }
}

