/*
 * Decompiled with CFR 0.152.
 */
package cucumber.formatter;

import cucumber.runtime.StepDefinitionMatch;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.formatter.Formatter;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UsageFormatter
implements Formatter,
Reporter {
    private static final BigDecimal NANOS_PER_SECOND = BigDecimal.valueOf(1000000000L);
    final Map<String, List<StepContainer>> usageMap = new HashMap<String, List<StepContainer>>();
    private final Map<String, UsageStatisticStrategy> statisticStrategies = new HashMap<String, UsageStatisticStrategy>();
    private final NiceAppendable out;
    private Match match;

    public UsageFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
        this.addUsageStatisticStrategy("median", new MedianUsageStatisticStrategy());
        this.addUsageStatisticStrategy("average", new AverageUsageStatisticStrategy());
    }

    public void uri(String uri) {
    }

    public void feature(Feature feature) {
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
    }

    public void embedding(String mimeType, InputStream data) {
    }

    public void write(String text) {
    }

    public void step(Step step) {
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void done() {
        ArrayList<StepDefContainer> stepDefContainers = new ArrayList<StepDefContainer>();
        for (Map.Entry<String, List<StepContainer>> usageEntry : this.usageMap.entrySet()) {
            StepDefContainer stepDefContainer = new StepDefContainer();
            stepDefContainers.add(stepDefContainer);
            stepDefContainer.source = usageEntry.getKey();
            stepDefContainer.steps = this.createStepContainer(usageEntry.getValue());
        }
        this.out.append((CharSequence)this.gson().toJson(stepDefContainers));
    }

    private List<StepContainer> createStepContainer(List<StepContainer> stepContainers) {
        for (StepContainer stepContainer : stepContainers) {
            stepContainer.aggregatedDurations = this.createAggregatedDurations(stepContainer);
            this.formatDurationAsSeconds(stepContainer.durations);
        }
        return stepContainers;
    }

    private void formatDurationAsSeconds(List<StepDuration> durations) {
        for (StepDuration duration : durations) {
            duration.duration = this.toSeconds(duration.duration.longValue());
        }
    }

    private Map<String, BigDecimal> createAggregatedDurations(StepContainer stepContainer) {
        HashMap<String, BigDecimal> aggregatedResults = new HashMap<String, BigDecimal>();
        for (Map.Entry<String, UsageStatisticStrategy> calculatorEntry : this.statisticStrategies.entrySet()) {
            UsageStatisticStrategy statisticStrategy = calculatorEntry.getValue();
            List<Long> rawDurations = this.getRawDurations(stepContainer.durations);
            Long calculationResult = statisticStrategy.calculate(rawDurations);
            String strategy = calculatorEntry.getKey();
            aggregatedResults.put(strategy, this.toSeconds(calculationResult));
        }
        return aggregatedResults;
    }

    private BigDecimal toSeconds(Long nanoSeconds) {
        return BigDecimal.valueOf(nanoSeconds).divide(NANOS_PER_SECOND);
    }

    private List<Long> getRawDurations(List<StepDuration> stepDurations) {
        ArrayList<Long> rawDurations = new ArrayList<Long>();
        for (StepDuration stepDuration : stepDurations) {
            rawDurations.add(stepDuration.duration.longValue());
        }
        return rawDurations;
    }

    private Gson gson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    public void close() {
        this.out.close();
    }

    public void result(Result result) {
        if (result.getStatus().equals("passed")) {
            this.addUsageEntry(result, this.getStepDefinition(), this.getStepName());
        }
    }

    public void before(Match match, Result result) {
    }

    public void after(Match match, Result result) {
    }

    private String getStepName() {
        return ((StepDefinitionMatch)this.match).getStepName();
    }

    private String getStepDefinition() {
        return ((StepDefinitionMatch)this.match).getPattern();
    }

    private void addUsageEntry(Result result, String stepDefinition, String stepNameWithArgs) {
        List<StepContainer> stepContainers = this.usageMap.get(stepDefinition);
        if (stepContainers == null) {
            stepContainers = new ArrayList<StepContainer>();
            this.usageMap.put(stepDefinition, stepContainers);
        }
        StepContainer stepContainer = this.findOrCreateStepContainer(stepNameWithArgs, stepContainers);
        String stepLocation = this.getStepLocation();
        Long duration = result.getDuration();
        StepDuration stepDuration = this.createStepDuration(duration, stepLocation);
        stepContainer.durations.add(stepDuration);
    }

    private String getStepLocation() {
        StackTraceElement stepLocation = ((StepDefinitionMatch)this.match).getStepLocation();
        return stepLocation.getFileName() + ":" + stepLocation.getLineNumber();
    }

    private StepDuration createStepDuration(Long duration, String location) {
        StepDuration stepDuration = new StepDuration();
        stepDuration.duration = duration == null ? BigDecimal.ZERO : BigDecimal.valueOf(duration);
        stepDuration.location = location;
        return stepDuration;
    }

    private StepContainer findOrCreateStepContainer(String stepNameWithArgs, List<StepContainer> stepContainers) {
        for (StepContainer container : stepContainers) {
            if (!stepNameWithArgs.equals(container.name)) continue;
            return container;
        }
        StepContainer stepContainer = new StepContainer();
        stepContainer.name = stepNameWithArgs;
        stepContainers.add(stepContainer);
        return stepContainer;
    }

    public void match(Match match) {
        this.match = match;
    }

    public void addUsageStatisticStrategy(String key, UsageStatisticStrategy strategy) {
        this.statisticStrategies.put(key, strategy);
    }

    static class MedianUsageStatisticStrategy
    implements UsageStatisticStrategy {
        MedianUsageStatisticStrategy() {
        }

        @Override
        public Long calculate(List<Long> durationEntries) {
            if (this.verifyNoNulls(durationEntries)) {
                return 0L;
            }
            Collections.sort(durationEntries);
            int middle = durationEntries.size() / 2;
            if (durationEntries.size() % 2 == 1) {
                return durationEntries.get(middle);
            }
            return (durationEntries.get(middle - 1) + durationEntries.get(middle)) / 2L;
        }

        private boolean verifyNoNulls(List<Long> durationEntries) {
            return durationEntries == null || durationEntries.isEmpty() || durationEntries.contains(null);
        }
    }

    static class AverageUsageStatisticStrategy
    implements UsageStatisticStrategy {
        AverageUsageStatisticStrategy() {
        }

        @Override
        public Long calculate(List<Long> durationEntries) {
            if (this.verifyNoNulls(durationEntries)) {
                return 0L;
            }
            long sum = 0L;
            for (Long duration : durationEntries) {
                sum += duration.longValue();
            }
            return sum / (long)durationEntries.size();
        }

        private boolean verifyNoNulls(List<Long> durationEntries) {
            return durationEntries == null || durationEntries.isEmpty() || durationEntries.contains(null);
        }
    }

    static interface UsageStatisticStrategy {
        public Long calculate(List<Long> var1);
    }

    static class StepDuration {
        public BigDecimal duration;
        public String location;

        StepDuration() {
        }
    }

    static class StepContainer {
        public String name;
        public Map<String, BigDecimal> aggregatedDurations = new HashMap<String, BigDecimal>();
        public List<StepDuration> durations = new ArrayList<StepDuration>();

        StepContainer() {
        }
    }

    static class StepDefContainer {
        public String source;
        public List<StepContainer> steps;

        StepDefContainer() {
        }
    }
}

