/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.elm.executing.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;

public class SameOrBeforeEvaluator {
    public static Boolean onOrBefore(Object left, Object right, String precision, State state) {
        if (left instanceof Interval && right instanceof Interval) {
            if (((Interval)left).getStart() instanceof BaseTemporal) {
                return SameOrBeforeEvaluator.sameOrBefore(((Interval)left).getEnd(), ((Interval)right).getStart(), precision, state);
            }
            return LessOrEqualEvaluator.lessOrEqual(((Interval)left).getEnd(), ((Interval)right).getStart(), state);
        }
        if (left instanceof Interval) {
            if (right instanceof BaseTemporal) {
                return SameOrBeforeEvaluator.sameOrBefore(((Interval)left).getEnd(), right, precision, state);
            }
            return LessOrEqualEvaluator.lessOrEqual(((Interval)left).getEnd(), right, state);
        }
        if (right instanceof Interval) {
            if (left instanceof BaseTemporal) {
                return SameOrBeforeEvaluator.sameOrBefore(left, ((Interval)right).getStart(), precision, state);
            }
            return LessOrEqualEvaluator.lessOrEqual(left, ((Interval)right).getStart(), state);
        }
        throw new InvalidOperatorArgument("OnOrBefore(Date, Date), OnOrBefore(DateTime, DateTime), OnOrBefore(Time, Time), OnOrBefore(Interval<T>, Interval<T>), OnOrBefore(T, Interval<T>) or OnOrBefore(Interval<T>, T)", String.format("OnOrBefore(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean sameOrBefore(Object left, Object right, String precision, State state) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval || right instanceof Interval) {
            return SameOrBeforeEvaluator.onOrBefore(left, right, precision, state);
        }
        if (precision == null) {
            precision = BaseTemporal.getHighestPrecision((BaseTemporal)left, (BaseTemporal)right);
        }
        if (left instanceof BaseTemporal && right instanceof BaseTemporal) {
            Integer result = ((BaseTemporal)left).compareToPrecision((BaseTemporal)right, Precision.fromString(precision));
            return result == null ? null : Boolean.valueOf(result == 0 || result < 0);
        }
        throw new InvalidOperatorArgument("SameOrBefore(Date, Date), SameOrBefore(DateTime, DateTime), SameOrBefore(Time, Time), SameOrBefore(Interval<T>, Interval<T>), SameOrBefore(T, Interval<T>) or SameOrBefore(Interval<T>, T)", String.format("SameOrBefore(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

