/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.util.stream.StreamSupport;
import org.opencds.cqf.cql.engine.elm.executing.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.IncludedInEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.NotEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameAsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class ProperIncludesEvaluator {
    public static Boolean properlyIncludes(Object left, Object right, String precision, State state) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right instanceof Interval ? ProperIncludesEvaluator.intervalProperlyIncludes(null, (Interval)right, precision, state) : ProperIncludesEvaluator.listProperlyIncludes(null, (Iterable)right, state);
        }
        if (right == null) {
            return left instanceof Interval ? ProperIncludesEvaluator.intervalProperlyIncludes((Interval)left, null, precision, state) : ProperIncludesEvaluator.listProperlyIncludes((Iterable)left, null, state);
        }
        if (left instanceof Interval && right instanceof Interval) {
            return ProperIncludesEvaluator.intervalProperlyIncludes((Interval)left, (Interval)right, precision, state);
        }
        if (left instanceof Iterable && right instanceof Iterable) {
            return ProperIncludesEvaluator.listProperlyIncludes((Iterable)left, (Iterable)right, state);
        }
        throw new InvalidOperatorArgument("ProperlyIncludes(Interval<T>, Interval<T>) or ProperlyIncludes(List<T>, List<T>)", String.format("ProperlyIncludes(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean intervalProperlyIncludes(Interval left, Interval right, String precision, State state) {
        if (left == null || right == null) {
            return null;
        }
        Object leftStart = left.getStart();
        Object leftEnd = left.getEnd();
        Object rightStart = right.getStart();
        Object rightEnd = right.getEnd();
        if (leftStart instanceof BaseTemporal || leftEnd instanceof BaseTemporal || rightStart instanceof BaseTemporal || rightEnd instanceof BaseTemporal) {
            Boolean isSame = AndEvaluator.and(SameAsEvaluator.sameAs(leftStart, rightStart, precision, state), SameAsEvaluator.sameAs(leftEnd, rightEnd, precision, state));
            return AndEvaluator.and(IncludedInEvaluator.intervalIncludedIn(right, left, precision, state), isSame == null ? null : Boolean.valueOf(isSame == false));
        }
        return AndEvaluator.and(IncludedInEvaluator.intervalIncludedIn(right, left, precision, state), NotEqualEvaluator.notEqual(left, right, state));
    }

    public static Boolean listProperlyIncludes(Iterable<?> left, Iterable<?> right, State state) {
        if (left == null) {
            return false;
        }
        int leftCount = (int)StreamSupport.stream(left.spliterator(), false).count();
        if (right == null) {
            return leftCount > 0;
        }
        return AndEvaluator.and(IncludedInEvaluator.listIncludedIn(right, left, state), GreaterEvaluator.greater(leftCount, (int)StreamSupport.stream(right.spliterator(), false).count(), state));
    }
}

