/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.elm.executing.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.executing.SameOrBeforeEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class OverlapsEvaluator {
    public static Boolean overlaps(Object left, Object right, String precision, State state) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Object leftStart = ((Interval)left).getStart();
            Object leftEnd = ((Interval)left).getEnd();
            Object rightStart = ((Interval)right).getStart();
            Object rightEnd = ((Interval)right).getEnd();
            if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
                return AndEvaluator.and(SameOrBeforeEvaluator.sameOrBefore(leftStart, rightEnd, precision, state), SameOrBeforeEvaluator.sameOrBefore(rightStart, leftEnd, precision, state));
            }
            return AndEvaluator.and(LessOrEqualEvaluator.lessOrEqual(leftStart, rightEnd, state), LessOrEqualEvaluator.lessOrEqual(rightStart, leftEnd, state));
        }
        throw new InvalidOperatorArgument("Overlaps(Interval<T>, Interval<T>)", String.format("Overlaps(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

